/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xerial.snappy.PureJavaCrc32C;

final class SnappyFramed {
    public static final int COMPRESSED_DATA_FLAG = 0;
    public static final int UNCOMPRESSED_DATA_FLAG = 1;
    public static final int STREAM_IDENTIFIER_FLAG = 255;
    private static final int MASK_DELTA = -1568478504;
    static final Class<? extends ByteBuffer> DIRECT_BUFFER_CLAZZ = SnappyFramed.lookupClassQuietly("java.nio.DirectByteBuffer");
    static final MethodHandle CLEAN_HANDLE;
    public static final byte[] HEADER_BYTES;

    SnappyFramed() {
    }

    public static int maskedCrc32c(byte[] data) {
        return SnappyFramed.maskedCrc32c(data, 0, data.length);
    }

    public static int maskedCrc32c(byte[] data, int offset, int length) {
        PureJavaCrc32C crc32c = new PureJavaCrc32C();
        crc32c.update(data, offset, length);
        return SnappyFramed.mask(crc32c.getIntegerValue());
    }

    public static int mask(int crc) {
        return (crc >>> 15 | crc << 17) + -1568478504;
    }

    static final int readBytes(ReadableByteChannel source, ByteBuffer dest) throws IOException {
        int lastRead;
        int expectedLength = dest.remaining();
        int totalRead = 0;
        totalRead = lastRead = source.read(dest);
        if (lastRead < expectedLength) {
            while (dest.remaining() != 0 && lastRead != -1) {
                lastRead = source.read(dest);
                if (lastRead == -1) continue;
                totalRead += lastRead;
            }
        }
        if (totalRead > 0) {
            dest.limit(dest.position());
        } else {
            dest.position(dest.limit());
        }
        return totalRead;
    }

    static int skip(ReadableByteChannel source, int skip, ByteBuffer buffer) throws IOException {
        if (skip <= 0) {
            return 0;
        }
        int toSkip = skip;
        int skipped = 0;
        while (toSkip > 0 && skipped != -1) {
            buffer.clear();
            if (toSkip < buffer.capacity()) {
                buffer.limit(toSkip);
            }
            if ((skipped = source.read(buffer)) <= 0) continue;
            toSkip -= skipped;
        }
        buffer.clear();
        return skip - toSkip;
    }

    private static Class<?> lookupClassQuietly(String name) {
        try {
            return SnappyFramed.class.getClassLoader().loadClass(name);
        }
        catch (Throwable t) {
            Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Did not find requested class: " + name, t);
            return null;
        }
    }

    static void releaseDirectByteBuffer(final ByteBuffer buffer) {
        assert (buffer != null && buffer.isDirect());
        if (CLEAN_HANDLE != null && DIRECT_BUFFER_CLAZZ.isInstance(buffer)) {
            try {
                PrivilegedExceptionAction<Void> pea = new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            CLEAN_HANDLE.invokeExact(buffer);
                        }
                        catch (Exception e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                        return null;
                    }
                };
                AccessController.doPrivileged(pea);
            }
            catch (Throwable t) {
                Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Exception occurred attempting to clean up Sun specific DirectByteBuffer.", t);
            }
        }
    }

    static boolean nonNull(Object o) {
        return o != null;
    }

    static {
        MethodHandle cleanHandle = null;
        try {
            PrivilegedExceptionAction<MethodHandle> action = new PrivilegedExceptionAction<MethodHandle>(){

                @Override
                public MethodHandle run() throws Exception {
                    MethodHandle handle = null;
                    if (DIRECT_BUFFER_CLAZZ != null) {
                        MethodHandles.Lookup lookup = MethodHandles.lookup();
                        try {
                            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
                            Field f = unsafeClass.getDeclaredField("theUnsafe");
                            f.setAccessible(true);
                            Object theUnsafe = f.get(null);
                            handle = unmapper.bindTo(theUnsafe);
                        }
                        catch (Exception e) {
                            Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "unable to use java 9 Unsafe.invokeCleaner", e);
                            Method m = DIRECT_BUFFER_CLAZZ.getMethod("cleaner", new Class[0]);
                            m.setAccessible(true);
                            MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
                            TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
                            MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
                            MethodHandle nonNullTest = lookup.findStatic(SnappyFramed.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
                            MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
                            handle = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
                        }
                    }
                    return handle;
                }
            };
            cleanHandle = AccessController.doPrivileged(action);
        }
        catch (Throwable t) {
            Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Exception occurred attempting to lookup Sun specific DirectByteBuffer cleaner classes.", t);
        }
        CLEAN_HANDLE = cleanHandle;
        HEADER_BYTES = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    }
}

