/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.AccessKeysInner;
import com.azure.resourcemanager.servicebus.fluent.models.SBAuthorizationRuleInner;
import com.azure.resourcemanager.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusNamespaceImpl;
import com.azure.resourcemanager.servicebus.models.NamespaceAuthorizationRule;
import com.azure.resourcemanager.servicebus.models.RegenerateAccessKeyParameters;
import reactor.core.publisher.Mono;

class NamespaceAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<NamespaceAuthorizationRule, ServiceBusNamespaceImpl, SBAuthorizationRuleInner, NamespaceAuthorizationRuleImpl, ServiceBusManager>
implements NamespaceAuthorizationRule,
NamespaceAuthorizationRule.Definition,
NamespaceAuthorizationRule.Update {
    NamespaceAuthorizationRuleImpl(String resourceGroupName, String namespaceName, String name, SBAuthorizationRuleInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.withExistingParentResource(resourceGroupName, namespaceName);
    }

    @Override
    public String namespaceName() {
        return this.parentName;
    }

    protected Mono<SBAuthorizationRuleInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getNamespaces().getAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.name());
    }

    protected Mono<NamespaceAuthorizationRule> createChildResourceAsync() {
        NamespaceAuthorizationRuleImpl self = this;
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getNamespaces().createOrUpdateAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.name(), ((SBAuthorizationRuleInner)((Object)this.innerModel())).rights()).map(inner -> {
            this.setInner(inner);
            return self;
        });
    }

    @Override
    protected Mono<AccessKeysInner> getKeysInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getNamespaces().listKeysAsync(this.resourceGroupName(), this.namespaceName(), this.name());
    }

    @Override
    protected Mono<AccessKeysInner> regenerateKeysInnerAsync(RegenerateAccessKeyParameters regenerateAccessKeyParameters) {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getNamespaces().regenerateKeysAsync(this.resourceGroupName(), this.namespaceName(), this.name(), regenerateAccessKeyParameters);
    }
}

