/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.extras.actions;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.extras.actions.DispatchAction;
import org.apache.struts.util.MessageResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LookupDispatchAction
extends DispatchAction {
    private static final long serialVersionUID = 8608624951935780151L;
    private final transient Logger log = LoggerFactory.getLogger(LookupDispatchAction.class);
    protected HashMap<Locale, Map<String, String>> localeMap = new HashMap();
    protected Map<String, String> keyMethodMap = null;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.execute(mapping, form, request, response);
    }

    private Map<String, String> initLookupMap(HttpServletRequest request, Locale userLocale) {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        this.keyMethodMap = this.getKeyMethodMap();
        ModuleConfig moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        MessageResourcesConfig[] mrc = moduleConfig.findMessageResourcesConfigs();
        for (int i = 0; i < mrc.length; ++i) {
            MessageResources resources = this.getResources(request, mrc[i].getKey());
            for (String key : this.keyMethodMap.keySet()) {
                String text = resources.getMessage(userLocale, key);
                if (text == null || lookupMap.containsKey(text)) continue;
                lookupMap.put(text, key);
            }
        }
        return lookupMap;
    }

    protected abstract Map<String, String> getKeyMethodMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLookupMapName(HttpServletRequest request, String keyName, ActionMapping mapping) throws ServletException {
        Map<String, String> lookupMap = null;
        HashMap<Locale, Map<String, String>> hashMap = this.localeMap;
        synchronized (hashMap) {
            Locale userLocale = this.getLocale(request);
            lookupMap = this.localeMap.get(userLocale);
            if (lookupMap == null) {
                lookupMap = this.initLookupMap(request, userLocale);
                this.localeMap.put(userLocale, lookupMap);
            }
        }
        String key = lookupMap.get(keyName);
        if (key == null) {
            String message = messages.getMessage("dispatch.resource", (Object)mapping.getPath());
            this.log.error("{} '{}'", (Object)message, (Object)keyName);
            throw new ServletException(message);
        }
        String methodName = this.keyMethodMap.get(key);
        if (methodName == null) {
            String message = messages.getMessage("dispatch.lookup", (Object)mapping.getPath(), (Object)key);
            throw new ServletException(message);
        }
        return methodName;
    }

    @Override
    protected String getMethodName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String parameter) throws Exception {
        String keyName = request.getParameter(parameter);
        if (keyName == null || keyName.length() == 0) {
            return null;
        }
        String methodName = this.getLookupMapName(request, keyName, mapping);
        return methodName;
    }
}

