/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.AzureBlobStorageApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.AzureTableStorageApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemApplicationLogsConfig;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ApplicationLogsConfig {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationLogsConfig.class);
    @JsonProperty(value="fileSystem")
    private FileSystemApplicationLogsConfig fileSystem;
    @JsonProperty(value="azureTableStorage")
    private AzureTableStorageApplicationLogsConfig azureTableStorage;
    @JsonProperty(value="azureBlobStorage")
    private AzureBlobStorageApplicationLogsConfig azureBlobStorage;

    public FileSystemApplicationLogsConfig fileSystem() {
        return this.fileSystem;
    }

    public ApplicationLogsConfig withFileSystem(FileSystemApplicationLogsConfig fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public AzureTableStorageApplicationLogsConfig azureTableStorage() {
        return this.azureTableStorage;
    }

    public ApplicationLogsConfig withAzureTableStorage(AzureTableStorageApplicationLogsConfig azureTableStorage) {
        this.azureTableStorage = azureTableStorage;
        return this;
    }

    public AzureBlobStorageApplicationLogsConfig azureBlobStorage() {
        return this.azureBlobStorage;
    }

    public ApplicationLogsConfig withAzureBlobStorage(AzureBlobStorageApplicationLogsConfig azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    public void validate() {
        if (this.fileSystem() != null) {
            this.fileSystem().validate();
        }
        if (this.azureTableStorage() != null) {
            this.azureTableStorage().validate();
        }
        if (this.azureBlobStorage() != null) {
            this.azureBlobStorage().validate();
        }
    }
}

