/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.PublishingProfile;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PublishingProfileImpl
implements PublishingProfile {
    private String ftpUrl;
    private String gitUrl;
    private String ftpUsername;
    private String gitUsername;
    private String ftpPassword;
    private String gitPassword;
    private final WebAppBase parent;
    private static final Pattern GIT_REGEX = Pattern.compile("publishMethod=\"MSDeploy\" publishUrl=\"([^\"]+)\".+userName=\"(\\$[^\"]+)\".+userPWD=\"([^\"]+)\"");
    private static final Pattern FTP_REGEX = Pattern.compile("publishMethod=\"FTP\" publishUrl=\"ftp://([^\"]+).+userName=\"([^\"]+\\\\\\$[^\"]+)\".+userPWD=\"([^\"]+)\"");

    PublishingProfileImpl(String publishingProfileXml, WebAppBase parent) {
        Matcher matcher = GIT_REGEX.matcher(publishingProfileXml);
        if (matcher.find()) {
            this.gitUrl = matcher.group(1);
            this.gitUsername = matcher.group(2);
            this.gitPassword = matcher.group(3);
        }
        if ((matcher = FTP_REGEX.matcher(publishingProfileXml)).find()) {
            this.ftpUrl = matcher.group(1);
            this.ftpUsername = matcher.group(2);
            this.ftpPassword = matcher.group(3);
        }
        this.parent = parent;
    }

    @Override
    public String ftpUrl() {
        return this.ftpUrl;
    }

    @Override
    public String ftpUsername() {
        return this.ftpUsername;
    }

    @Override
    public String gitUrl() {
        String repoName = this.parent instanceof DeploymentSlot ? ((WebApp)((DeploymentSlot)this.parent).parent()).name() + ".git" : this.parent.name() + ".git";
        if (!this.gitUrl.startsWith("https://")) {
            this.gitUrl = "https://" + this.gitUrl;
        }
        return this.gitUrl + "/" + repoName;
    }

    @Override
    public String gitUsername() {
        return this.gitUsername;
    }

    @Override
    public String ftpPassword() {
        return this.ftpPassword;
    }

    @Override
    public String gitPassword() {
        return this.gitPassword;
    }
}

