/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class CertificatePatchResourceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CertificatePatchResourceProperties.class);
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="friendlyName", access=JsonProperty.Access.WRITE_ONLY)
    private String friendlyName;
    @JsonProperty(value="subjectName", access=JsonProperty.Access.WRITE_ONLY)
    private String subjectName;
    @JsonProperty(value="hostNames")
    private List<String> hostNames;
    @JsonProperty(value="pfxBlob")
    private byte[] pfxBlob;
    @JsonProperty(value="siteName", access=JsonProperty.Access.WRITE_ONLY)
    private String siteName;
    @JsonProperty(value="selfLink", access=JsonProperty.Access.WRITE_ONLY)
    private String selfLink;
    @JsonProperty(value="issuer", access=JsonProperty.Access.WRITE_ONLY)
    private String issuer;
    @JsonProperty(value="issueDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime issueDate;
    @JsonProperty(value="expirationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expirationDate;
    @JsonProperty(value="thumbprint", access=JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;
    @JsonProperty(value="valid", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean valid;
    @JsonProperty(value="cerBlob", access=JsonProperty.Access.WRITE_ONLY)
    private byte[] cerBlob;
    @JsonProperty(value="publicKeyHash", access=JsonProperty.Access.WRITE_ONLY)
    private String publicKeyHash;
    @JsonProperty(value="hostingEnvironmentProfile", access=JsonProperty.Access.WRITE_ONLY)
    private HostingEnvironmentProfile hostingEnvironmentProfile;
    @JsonProperty(value="keyVaultId")
    private String keyVaultId;
    @JsonProperty(value="keyVaultSecretName")
    private String keyVaultSecretName;
    @JsonProperty(value="keyVaultSecretStatus", access=JsonProperty.Access.WRITE_ONLY)
    private KeyVaultSecretStatus keyVaultSecretStatus;
    @JsonProperty(value="serverFarmId")
    private String serverFarmId;
    @JsonProperty(value="canonicalName")
    private String canonicalName;
    @JsonProperty(value="domainValidationMethod")
    private String domainValidationMethod;

    public String password() {
        return this.password;
    }

    public CertificatePatchResourceProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public String friendlyName() {
        return this.friendlyName;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public CertificatePatchResourceProperties withHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public byte[] pfxBlob() {
        return CoreUtils.clone((byte[])this.pfxBlob);
    }

    public CertificatePatchResourceProperties withPfxBlob(byte[] pfxBlob) {
        this.pfxBlob = CoreUtils.clone((byte[])pfxBlob);
        return this;
    }

    public String siteName() {
        return this.siteName;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public String issuer() {
        return this.issuer;
    }

    public OffsetDateTime issueDate() {
        return this.issueDate;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean valid() {
        return this.valid;
    }

    public byte[] cerBlob() {
        return CoreUtils.clone((byte[])this.cerBlob);
    }

    public String publicKeyHash() {
        return this.publicKeyHash;
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public CertificatePatchResourceProperties withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    public String keyVaultSecretName() {
        return this.keyVaultSecretName;
    }

    public CertificatePatchResourceProperties withKeyVaultSecretName(String keyVaultSecretName) {
        this.keyVaultSecretName = keyVaultSecretName;
        return this;
    }

    public KeyVaultSecretStatus keyVaultSecretStatus() {
        return this.keyVaultSecretStatus;
    }

    public String serverFarmId() {
        return this.serverFarmId;
    }

    public CertificatePatchResourceProperties withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public CertificatePatchResourceProperties withCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        return this;
    }

    public String domainValidationMethod() {
        return this.domainValidationMethod;
    }

    public CertificatePatchResourceProperties withDomainValidationMethod(String domainValidationMethod) {
        this.domainValidationMethod = domainValidationMethod;
        return this;
    }

    public void validate() {
        if (this.hostingEnvironmentProfile() != null) {
            this.hostingEnvironmentProfile().validate();
        }
    }
}

