/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.GeoFilterActions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class GeoFilter {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(GeoFilter.class);
    @JsonProperty(value="relativePath", required=true)
    private String relativePath;
    @JsonProperty(value="action", required=true)
    private GeoFilterActions action;
    @JsonProperty(value="countryCodes", required=true)
    private List<String> countryCodes;

    public String relativePath() {
        return this.relativePath;
    }

    public GeoFilter withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public GeoFilterActions action() {
        return this.action;
    }

    public GeoFilter withAction(GeoFilterActions action) {
        this.action = action;
        return this;
    }

    public List<String> countryCodes() {
        return this.countryCodes;
    }

    public GeoFilter withCountryCodes(List<String> countryCodes) {
        this.countryCodes = countryCodes;
        return this;
    }

    public void validate() {
        if (this.relativePath() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property relativePath in model GeoFilter"));
        }
        if (this.action() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property action in model GeoFilter"));
        }
        if (this.countryCodes() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property countryCodes in model GeoFilter"));
        }
    }
}

