/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles2.preparer;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.apache.tiles.request.Request;

public class UrlPreparer
implements ViewPreparer {
    private String url;

    public UrlPreparer(String url) {
        this.url = url;
    }

    public void execute(Request tilesContext, AttributeContext attributeContext) throws PreparerException {
        if (tilesContext instanceof org.apache.tiles.request.jakarta.servlet.ServletRequest) {
            org.apache.tiles.request.jakarta.servlet.ServletRequest servletTilesContext = (org.apache.tiles.request.jakarta.servlet.ServletRequest)tilesContext;
            HttpServletRequest request = servletTilesContext.getRequest();
            HttpServletResponse response = servletTilesContext.getResponse();
            RequestDispatcher rd = request.getSession().getServletContext().getRequestDispatcher(this.url);
            if (rd == null) {
                throw new PreparerException("Controller can't find url '" + this.url + "'.");
            }
            try {
                rd.include((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                throw new PreparerException("The request dispatcher threw an exception", (Throwable)e);
            }
            catch (IOException e) {
                throw new PreparerException("The request dispatcher threw an I/O exception", (Throwable)e);
            }
        } else {
            throw new PreparerException("Cannot dispatch url '" + this.url + "' since this preparer has not been called under a servlet environment");
        }
    }
}

