/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles2;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.struts.tiles2.TilesPluginContainer;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesPluginContainerFactory
extends BasicTilesContainerFactory {
    private final transient Logger log = LoggerFactory.getLogger(TilesPluginContainerFactory.class);

    public TilesContainer createContainer(ApplicationContext applicationContext) {
        TilesPluginContainer container = this.instantiateContainer(applicationContext);
        container.setApplicationContext(applicationContext);
        LocaleResolver resolver = this.createLocaleResolver(applicationContext);
        container.setLocaleResolver(resolver);
        container.setDefinitionsFactory(this.createDefinitionsFactory(applicationContext, resolver));
        AttributeEvaluatorFactory attributeEvaluatorFactory = this.createAttributeEvaluatorFactory(applicationContext, resolver);
        container.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        container.setPreparerFactory(this.createPreparerFactory(applicationContext));
        TilesContainer injectedContainer = this.createDecoratedContainer((TilesContainer)container, applicationContext);
        container.setRendererFactory(this.createRendererFactory(applicationContext, injectedContainer, attributeEvaluatorFactory));
        return injectedContainer;
    }

    protected TilesPluginContainer instantiateContainer(ApplicationContext context) {
        return new TilesPluginContainer();
    }

    protected List<ApplicationResource> getSources(ApplicationContext applicationContext) {
        String param = (String)applicationContext.getInitParams().get("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG");
        if (param == null) {
            param = (String)applicationContext.getInitParams().get("definitions-config");
        }
        boolean error = true;
        if (param != null) {
            if (param.isEmpty()) {
                this.log.warn("getSources - empty parameters");
            } else if (param.contains("\u0000")) {
                this.log.warn("getSources - ignore file with nul-characters '{}'", (Object)param.replace('\u0000', '_'));
            } else {
                try {
                    Path p = Paths.get(param, new String[0]).normalize();
                    if (p.toString().charAt(0) != '.') {
                        error = false;
                    } else {
                        this.log.warn("getSources - path not normalized '{}'", (Object)p.toString());
                    }
                }
                catch (InvalidPathException e) {
                    this.log.warn("getSources - illegal path '{}'", (Object)e.getInput(), (Object)e);
                    param = null;
                }
            }
        }
        if (error) {
            param = "/WEB-INF/tiles.xml";
            this.log.debug("getSources - use default '{}'", (Object)param);
        } else {
            this.log.debug("getSources - use '{}'", (Object)param);
        }
        return Collections.singletonList(applicationContext.getResource(param));
    }

    public DefinitionsFactory createDefinitionsFactory(TilesPluginContainer container, ApplicationContext applicationContext) {
        LocaleResolver resolver = container.getLocaleResolverIntern();
        return this.createDefinitionsFactory(applicationContext, resolver);
    }
}

