/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles2;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.ModuleUtils;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.jakarta.servlet.ServletRequest;

public class TilesPluginContainer
extends BasicTilesContainer {
    private final Map<String, DefinitionsFactory> key2definitionsFactory = new HashMap<String, DefinitionsFactory>();
    private LocaleResolver localeResolver;

    void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    LocaleResolver getLocaleResolverIntern() {
        return this.localeResolver;
    }

    public DefinitionsFactory getProperDefinitionsFactory(String key) {
        DefinitionsFactory retValue = null;
        if (key != null) {
            retValue = this.key2definitionsFactory.get(key);
        }
        return retValue;
    }

    public void setDefinitionsFactory(String key, DefinitionsFactory definitionsFactory) {
        if (key != null) {
            this.key2definitionsFactory.put(key, definitionsFactory);
        } else {
            this.setDefinitionsFactory(definitionsFactory);
        }
    }

    public Definition getDefinition(String definitionName, Request request) {
        DefinitionsFactory definitionsFactory;
        Definition retValue = null;
        String key = this.getDefinitionsFactoryKey(request);
        if (key != null && (definitionsFactory = this.key2definitionsFactory.get(key)) != null) {
            retValue = definitionsFactory.getDefinition(definitionName, request);
        }
        if (retValue == null) {
            retValue = super.getDefinition(definitionName, request);
        }
        return retValue;
    }

    protected String getDefinitionsFactoryKey(Request request) {
        String retValue = null;
        if (request instanceof ServletRequest) {
            HttpServletRequest servletRequest = ((ServletRequest)request).getRequest();
            ModuleConfig config = ModuleUtils.getInstance().getModuleConfig(servletRequest);
            if (config == null) {
                ModuleUtils.getInstance().selectModule(servletRequest, servletRequest.getSession().getServletContext());
                config = ModuleUtils.getInstance().getModuleConfig(servletRequest);
            }
            if (config != null) {
                retValue = config.getPrefix();
            }
        }
        return retValue;
    }
}

