/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles2;

import jakarta.servlet.ServletException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.chain.ComposableRequestProcessor;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.tiles2.TilesPluginContainer;
import org.apache.struts.tiles2.TilesPluginContainerFactory;
import org.apache.struts.tiles2.TilesRequestProcessor;
import org.apache.struts.tiles2.util.PlugInConfigContextAdapter;
import org.apache.struts.util.RequestUtils;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.request.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TilesPlugin
implements PlugIn {
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private final Logger log = LoggerFactory.getLogger(TilesPlugin.class);
    protected boolean moduleAware = false;
    protected PlugInConfig currentPlugInConfigObject = null;
    protected PlugInConfigContextAdapter currentPlugInConfigContextAdapter = null;

    public boolean isModuleAware() {
        return this.moduleAware;
    }

    public void setModuleAware(boolean moduleAware) {
        this.moduleAware = moduleAware;
    }

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        this.currentPlugInConfigContextAdapter = new PlugInConfigContextAdapter(this.currentPlugInConfigObject, servlet.getServletContext());
        this.initRequestProcessorClass(moduleConfig);
        try {
            if (this.moduleAware) {
                TilesPluginContainerFactory factory = new TilesPluginContainerFactory();
                TilesContainer container = TilesAccess.getContainer((ApplicationContext)this.currentPlugInConfigContextAdapter);
                if (container == null) {
                    container = factory.createContainer((ApplicationContext)this.currentPlugInConfigContextAdapter);
                    TilesAccess.setContainer((ApplicationContext)this.currentPlugInConfigContextAdapter, (TilesContainer)container);
                }
                if (container instanceof TilesPluginContainer) {
                    TilesPluginContainer pluginContainer = (TilesPluginContainer)container;
                    if (pluginContainer.getProperDefinitionsFactory(moduleConfig.getPrefix()) != null) {
                        throw new ServletException("Tiles definitions factory for module '" + moduleConfig.getPrefix() + "' has already been configured");
                    }
                    DefinitionsFactory defsFactory = factory.createDefinitionsFactory(pluginContainer, (ApplicationContext)this.currentPlugInConfigContextAdapter);
                    pluginContainer.setDefinitionsFactory(moduleConfig.getPrefix(), defsFactory);
                } else {
                    this.log.warn("The created container is not instance of TilesPluginContainer and cannot be configured correctly");
                }
            } else {
                if (this.currentPlugInConfigContextAdapter.getApplicationScope().containsKey("org.apache.tiles.CONTAINER")) {
                    throw new ServletException("Tiles container has already been configured");
                }
                TilesPluginContainerFactory factory = new TilesPluginContainerFactory();
                TilesContainer container = factory.createContainer((ApplicationContext)this.currentPlugInConfigContextAdapter);
                TilesAccess.setContainer((ApplicationContext)this.currentPlugInConfigContextAdapter, (TilesContainer)container);
            }
        }
        catch (TilesException e) {
            this.log.error(FATAL, "Unable to retrieve tiles factory.", (Throwable)e);
            throw new IllegalStateException("Unable to instantiate container.");
        }
    }

    public void destroy() {
        try {
            TilesAccess.setContainer((ApplicationContext)this.currentPlugInConfigContextAdapter, null);
        }
        catch (TilesException e) {
            this.log.warn("Unable to remove tiles container from service.");
        }
    }

    protected void initRequestProcessorClass(ModuleConfig config) throws ServletException {
        Class configProcessorClass;
        String tilesProcessorClassname = TilesRequestProcessor.class.getName();
        ControllerConfig ctrlConfig = config.getControllerConfig();
        String configProcessorClassname = ctrlConfig.getProcessorClass();
        try {
            configProcessorClass = RequestUtils.applicationClass((String)configProcessorClassname);
        }
        catch (ClassNotFoundException ex) {
            this.log.error(FATAL, "Can't set TilesRequestProcessor: bad class name '{}'.", (Object)configProcessorClassname);
            throw new ServletException((Throwable)ex);
        }
        if (ComposableRequestProcessor.class.isAssignableFrom(configProcessorClass)) {
            return;
        }
        if (configProcessorClassname.equals(RequestProcessor.class.getName()) || configProcessorClassname.endsWith(tilesProcessorClassname)) {
            ctrlConfig.setProcessorClass(tilesProcessorClassname);
            return;
        }
        Class<TilesRequestProcessor> tilesProcessorClass = TilesRequestProcessor.class;
        if (!tilesProcessorClass.isAssignableFrom(configProcessorClass)) {
            String msg = "TilesPlugin : Specified RequestProcessor not compatible with TilesRequestProcessor";
            this.log.error(FATAL, msg);
            throw new ServletException(msg);
        }
    }

    public void setCurrentPlugInConfigObject(PlugInConfig plugInConfigObject) {
        this.currentPlugInConfigObject = plugInConfigObject;
    }
}

