/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.bytes;

import dorkbox.util.bytes.UInteger;
import dorkbox.util.bytes.ULong;
import dorkbox.util.bytes.UShort;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class LittleEndian {

    public static final class Char_ {
        public static char from(byte[] bytes, int offset, int byteNum) {
            char number = '\u0000';
            switch (byteNum) {
                case 2: {
                    number = (char)(number | (bytes[offset + 1] & 0xFF) << 8);
                }
                case 1: {
                    number = (char)(number | (bytes[offset + 0] & 0xFF) << 0);
                }
            }
            return number;
        }

        public static char from(byte[] bytes) {
            char number = '\u0000';
            switch (bytes.length) {
                case 2: {
                    number = (char)(number | (bytes[1] & 0xFF) << 8);
                }
                case 1: {
                    number = (char)(number | (bytes[0] & 0xFF) << 0);
                }
            }
            return number;
        }

        public static char from(byte b0, byte b1) {
            return (char)((b1 & 0xFF) << 8 | (b0 & 0xFF) << 0);
        }

        public static byte[] toBytes(char x) {
            return new byte[]{(byte)(x >> 0), (byte)(x >> 8)};
        }

        public static char from(ByteBuffer buff) {
            return Char_.from(buff.get(), buff.get());
        }

        public static char from(InputStream inputStream) throws IOException {
            byte[] b = new byte[2];
            if (inputStream.read(b) != 2) {
                throw new EOFException();
            }
            return Char_.from(b[0], b[1]);
        }

        private Char_() {
        }
    }

    public static final class Int_ {
        public static int from(byte[] bytes, int offset, int bytenum) {
            int number = 0;
            switch (bytenum) {
                case 4: {
                    number |= (bytes[offset + 3] & 0xFF) << 24;
                }
                case 3: {
                    number |= (bytes[offset + 2] & 0xFF) << 16;
                }
                case 2: {
                    number |= (bytes[offset + 1] & 0xFF) << 8;
                }
                case 1: {
                    number |= (bytes[offset + 0] & 0xFF) << 0;
                }
            }
            return number;
        }

        public static int from(byte[] bytes) {
            int number = 0;
            switch (bytes.length) {
                case 4: {
                    number |= (bytes[3] & 0xFF) << 24;
                }
                case 3: {
                    number |= (bytes[2] & 0xFF) << 16;
                }
                case 2: {
                    number |= (bytes[1] & 0xFF) << 8;
                }
                case 1: {
                    number |= (bytes[0] & 0xFF) << 0;
                }
            }
            return number;
        }

        public static int from(byte b0, byte b1, byte b2, byte b3) {
            return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
        }

        public static byte[] toBytes(int x) {
            return new byte[]{(byte)(x >> 0), (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24)};
        }

        public static int from(ByteBuffer buff) {
            return Int_.from(buff.get(), buff.get(), buff.get(), buff.get());
        }

        public static int from(InputStream inputStream) throws IOException {
            byte[] b = new byte[4];
            if (inputStream.read(b) != 4) {
                throw new EOFException();
            }
            return Int_.from(b[0], b[1], b[2], b[3]);
        }

        private Int_() {
        }
    }

    public static final class Long_ {
        public static long from(byte[] bytes, int offset, int bytenum) {
            long number = 0L;
            switch (bytenum) {
                case 8: {
                    number |= (long)(bytes[offset + 7] & 0xFF) << 56;
                }
                case 7: {
                    number |= (long)(bytes[offset + 6] & 0xFF) << 48;
                }
                case 6: {
                    number |= (long)(bytes[offset + 5] & 0xFF) << 40;
                }
                case 5: {
                    number |= (long)(bytes[offset + 4] & 0xFF) << 32;
                }
                case 4: {
                    number |= (long)(bytes[offset + 3] & 0xFF) << 24;
                }
                case 3: {
                    number |= (long)(bytes[offset + 2] & 0xFF) << 16;
                }
                case 2: {
                    number |= (long)(bytes[offset + 1] & 0xFF) << 8;
                }
                case 1: {
                    number |= (long)(bytes[offset + 0] & 0xFF) << 0;
                }
            }
            return number;
        }

        public static long from(byte[] bytes) {
            long number = 0L;
            switch (bytes.length) {
                case 8: {
                    number |= (long)(bytes[7] & 0xFF) << 56;
                }
                case 7: {
                    number |= (long)(bytes[6] & 0xFF) << 48;
                }
                case 6: {
                    number |= (long)(bytes[5] & 0xFF) << 40;
                }
                case 5: {
                    number |= (long)(bytes[4] & 0xFF) << 32;
                }
                case 4: {
                    number |= (long)(bytes[3] & 0xFF) << 24;
                }
                case 3: {
                    number |= (long)(bytes[2] & 0xFF) << 16;
                }
                case 2: {
                    number |= (long)(bytes[1] & 0xFF) << 8;
                }
                case 1: {
                    number |= (long)(bytes[0] & 0xFF) << 0;
                }
            }
            return number;
        }

        public static long from(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
            return (long)(b7 & 0xFF) << 56 | (long)(b6 & 0xFF) << 48 | (long)(b5 & 0xFF) << 40 | (long)(b4 & 0xFF) << 32 | (long)(b3 & 0xFF) << 24 | (long)(b2 & 0xFF) << 16 | (long)(b1 & 0xFF) << 8 | (long)(b0 & 0xFF) << 0;
        }

        public static byte[] toBytes(long x) {
            return new byte[]{(byte)(x >> 0), (byte)(x >> 8), (byte)(x >> 16), (byte)(x >> 24), (byte)(x >> 32), (byte)(x >> 40), (byte)(x >> 48), (byte)(x >> 56)};
        }

        public static long from(ByteBuffer buff) {
            return Long_.from(buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get());
        }

        public static long from(InputStream inputStream) throws IOException {
            byte[] b = new byte[8];
            if (inputStream.read(b) != 8) {
                throw new EOFException();
            }
            return Long_.from(b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7]);
        }

        private Long_() {
        }
    }

    public static final class Short_ {
        public static short from(byte[] bytes, int offset, int bytenum) {
            short number = 0;
            switch (bytenum) {
                case 2: {
                    number = (short)(number | (bytes[offset + 1] & 0xFF) << 8);
                }
                case 1: {
                    number = (short)(number | (bytes[offset + 0] & 0xFF) << 0);
                }
            }
            return number;
        }

        public static short from(byte[] bytes) {
            short number = 0;
            switch (bytes.length) {
                case 2: {
                    number = (short)(number | (bytes[1] & 0xFF) << 8);
                }
                case 1: {
                    number = (short)(number | (bytes[0] & 0xFF) << 0);
                }
            }
            return number;
        }

        public static short from(byte b0, byte b1) {
            return (short)((b1 & 0xFF) << 8 | (b0 & 0xFF) << 0);
        }

        public static byte[] toBytes(short x) {
            return new byte[]{(byte)(x >> 0), (byte)(x >> 8)};
        }

        public static short from(ByteBuffer buff) {
            return Short_.from(buff.get(), buff.get());
        }

        public static short from(InputStream inputStream) throws IOException {
            byte[] b = new byte[2];
            if (inputStream.read(b) != 2) {
                throw new EOFException();
            }
            return Short_.from(b[0], b[1]);
        }

        private Short_() {
        }
    }

    public static final class UChar_ {
        public static UShort from(byte[] bytes, int offset, int bytenum) {
            int number = 0;
            switch (bytenum) {
                case 2: {
                    number = (char)(number | (bytes[offset + 1] & 0xFF) << 8);
                }
                case 1: {
                    number = (char)(number | (bytes[offset + 0] & 0xFF) << 0);
                }
            }
            return UShort.valueOf(number);
        }

        public static UShort from(byte[] bytes) {
            short number = 0;
            switch (bytes.length) {
                case 2: {
                    number = (short)(number | (bytes[1] & 0xFF) << 8);
                }
                case 1: {
                    number = (short)(number | (bytes[0] & 0xFF) << 0);
                }
            }
            return UShort.valueOf(number);
        }

        public static UShort from(byte b0, byte b1) {
            return UShort.valueOf((short)((b1 & 0xFF) << 8) | (b0 & 0xFF) << 0);
        }

        public static byte[] toBytes(UShort x) {
            int num = x.intValue();
            return new byte[]{(byte)(num & 0xFF), (byte)((num & 0xFF00) >> 8)};
        }

        public static UShort from(ByteBuffer buff) {
            return UChar_.from(buff.get(), buff.get());
        }

        public static UShort from(InputStream inputStream) throws IOException {
            byte[] b = new byte[2];
            if (inputStream.read(b) != 2) {
                throw new EOFException();
            }
            return UChar_.from(b[0], b[1]);
        }

        private UChar_() {
        }
    }

    public static final class UInt_ {
        public static UInteger from(byte[] bytes, int offset, int bytenum) {
            int number = 0;
            switch (bytenum) {
                case 4: {
                    number |= (bytes[offset + 3] & 0xFF) << 24;
                }
                case 3: {
                    number |= (bytes[offset + 2] & 0xFF) << 16;
                }
                case 2: {
                    number |= (bytes[offset + 1] & 0xFF) << 8;
                }
                case 1: {
                    number |= (bytes[offset + 0] & 0xFF) << 0;
                }
            }
            return UInteger.valueOf(number);
        }

        public static UInteger from(byte[] bytes) {
            int number = 0;
            switch (bytes.length) {
                case 4: {
                    number |= (bytes[3] & 0xFF) << 24;
                }
                case 3: {
                    number |= (bytes[2] & 0xFF) << 16;
                }
                case 2: {
                    number |= (bytes[1] & 0xFF) << 8;
                }
                case 1: {
                    number |= (bytes[0] & 0xFF) << 0;
                }
            }
            return UInteger.valueOf(number);
        }

        public static UInteger from(byte b0, byte b1, byte b2, byte b3) {
            int number = (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
            return UInteger.valueOf(number);
        }

        public static byte[] toBytes(UInteger x) {
            long num = x.longValue();
            return new byte[]{(byte)(num & 0xFFL), (byte)((num & 0xFF00L) >> 8), (byte)((num & 0xFF0000L) >> 16), (byte)((num & 0xFF000000L) >> 24)};
        }

        public static UInteger from(ByteBuffer buff) {
            return UInt_.from(buff.get(), buff.get(), buff.get(), buff.get());
        }

        public static UInteger from(InputStream inputStream) throws IOException {
            byte[] b = new byte[4];
            if (inputStream.read(b) != 4) {
                throw new EOFException();
            }
            return UInt_.from(b[0], b[1], b[2], b[3]);
        }

        private UInt_() {
        }
    }

    public static final class ULong_ {
        public static ULong from(byte[] bytes, int offset, int bytenum) {
            long number = 0L;
            switch (bytenum) {
                case 8: {
                    number |= (long)(bytes[offset + 7] & 0xFF) << 56;
                }
                case 7: {
                    number |= (long)(bytes[offset + 6] & 0xFF) << 48;
                }
                case 6: {
                    number |= (long)(bytes[offset + 5] & 0xFF) << 40;
                }
                case 5: {
                    number |= (long)(bytes[offset + 4] & 0xFF) << 32;
                }
                case 4: {
                    number |= (long)(bytes[offset + 3] & 0xFF) << 24;
                }
                case 3: {
                    number |= (long)(bytes[offset + 2] & 0xFF) << 16;
                }
                case 2: {
                    number |= (long)(bytes[offset + 1] & 0xFF) << 8;
                }
                case 1: {
                    number |= (long)(bytes[offset + 0] & 0xFF) << 0;
                }
            }
            return ULong.valueOf(number);
        }

        public static ULong from(byte[] bytes) {
            BigInteger ulong = new BigInteger(1, bytes);
            return ULong.valueOf(ulong);
        }

        public static ULong from(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
            byte[] bytes = new byte[]{b7, b6, b5, b4, b3, b2, b1, b0};
            BigInteger ulong = new BigInteger(1, bytes);
            return ULong.valueOf(ulong);
        }

        public static byte[] toBytes(ULong x) {
            byte[] bytes = new byte[8];
            int offset = 0;
            byte[] temp_byte = x.toBigInteger().toByteArray();
            int array_count = temp_byte.length - 1;
            for (int i = 7; i >= 0; --i) {
                bytes[offset] = array_count >= 0 ? temp_byte[array_count] : (byte)0;
                ++offset;
                --array_count;
            }
            return bytes;
        }

        public static ULong from(ByteBuffer buff) {
            return ULong_.from(buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get());
        }

        public static ULong from(InputStream inputStream) throws IOException {
            byte[] b = new byte[8];
            if (inputStream.read(b) != 8) {
                throw new EOFException();
            }
            return ULong_.from(b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7]);
        }

        private ULong_() {
        }
    }

    public static final class UShort_ {
        public static UShort from(byte[] bytes, int offset, int bytenum) {
            short number = 0;
            switch (bytenum) {
                case 2: {
                    number = (short)(number | (bytes[offset + 1] & 0xFF) << 8);
                }
                case 1: {
                    number = (short)(number | (bytes[offset + 0] & 0xFF) << 0);
                }
            }
            return UShort.valueOf(number);
        }

        public static UShort from(byte[] bytes) {
            short number = 0;
            switch (bytes.length) {
                case 2: {
                    number = (short)(number | (bytes[1] & 0xFF) << 8);
                }
                case 1: {
                    number = (short)(number | (bytes[0] & 0xFF) << 0);
                }
            }
            return UShort.valueOf(number);
        }

        public static UShort from(byte b0, byte b1) {
            return UShort.valueOf((short)((b1 & 0xFF) << 8 | (b0 & 0xFF) << 0));
        }

        public static byte[] toBytes(UShort x) {
            int num = x.intValue();
            return new byte[]{(byte)(num & 0xFF), (byte)((num & 0xFF00) >> 8)};
        }

        public static UShort from(ByteBuffer buff) {
            return UShort_.from(buff.get(), buff.get());
        }

        public static UShort from(InputStream inputStream) throws IOException {
            byte[] b = new byte[2];
            if (inputStream.read(b) != 2) {
                throw new EOFException();
            }
            return UShort_.from(b[0], b[1]);
        }

        private UShort_() {
        }
    }
}

