/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;

public class PDStream
implements COSObjectable {
    private final COSStream stream;

    public PDStream(PDDocument document) {
        this.stream = document.getDocument().createCOSStream();
    }

    public PDStream(COSDocument document) {
        this.stream = document.createCOSStream();
    }

    public PDStream(COSStream str) {
        this.stream = str;
    }

    public PDStream(PDDocument doc, InputStream input) throws IOException {
        this(doc, input, (COSBase)null);
    }

    public PDStream(PDDocument doc, InputStream input, COSName filter) throws IOException {
        this(doc, input, (COSBase)filter);
    }

    public PDStream(PDDocument doc, InputStream input, COSArray filters) throws IOException {
        this(doc, input, (COSBase)filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDStream(PDDocument doc, InputStream input, COSBase filters) throws IOException {
        OutputStream output = null;
        try {
            this.stream = doc.getDocument().createCOSStream();
            output = this.stream.createOutputStream(filters);
            IOUtils.copy(input, output);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    @Deprecated
    public void addCompression() {
        block4: {
            List<COSName> filters;
            block5: {
                filters = this.getFilters();
                if (filters != null) break block4;
                if (this.stream.getLength() <= 0L) break block5;
                OutputStream out = null;
                try {
                    byte[] bytes = IOUtils.toByteArray(this.stream.createInputStream());
                    out = this.stream.createOutputStream(COSName.FLATE_DECODE);
                    out.write(bytes);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(out);
                break block4;
            }
            filters = new ArrayList<COSName>();
            filters.add(COSName.FLATE_DECODE);
            this.setFilters(filters);
        }
    }

    @Override
    public COSStream getCOSObject() {
        return this.stream;
    }

    public OutputStream createOutputStream() throws IOException {
        return this.stream.createOutputStream();
    }

    public OutputStream createOutputStream(COSName filter) throws IOException {
        return this.stream.createOutputStream(filter);
    }

    public COSInputStream createInputStream() throws IOException {
        return this.stream.createInputStream();
    }

    public InputStream createInputStream(List<String> stopFilters) throws IOException {
        InputStream is = this.stream.createRawInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        List<COSName> filters = this.getFilters();
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                COSName nextFilter = filters.get(i);
                if (stopFilters != null && stopFilters.contains(nextFilter.getName())) break;
                Filter filter = FilterFactory.INSTANCE.getFilter(nextFilter);
                filter.decode(is, os, this.stream, i);
                IOUtils.closeQuietly(is);
                is = new ByteArrayInputStream(os.toByteArray());
                os.reset();
            }
        }
        return is;
    }

    @Deprecated
    public COSStream getStream() {
        return this.stream;
    }

    public int getLength() {
        return this.stream.getInt(COSName.LENGTH, 0);
    }

    public List<COSName> getFilters() {
        List<?> retval = null;
        COSBase filters = this.stream.getFilters();
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList<COSName>(name, name, this.stream, COSName.FILTER);
        } else if (filters instanceof COSArray) {
            retval = ((COSArray)filters).toList();
        }
        return retval;
    }

    public void setFilters(List<COSName> filters) {
        COSArray obj = COSArrayList.converterToCOSArray(filters);
        this.stream.setItem(COSName.FILTER, (COSBase)obj);
    }

    public List<Object> getDecodeParms() throws IOException {
        COSArrayList<COSDictionaryMap<String, Object>> retval = null;
        COSBase dp = this.stream.getDictionaryObject(COSName.DECODE_PARMS);
        if (dp == null) {
            dp = this.stream.getDictionaryObject(COSName.DP);
        }
        if (dp instanceof COSDictionary) {
            COSDictionaryMap<String, Object> map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList<COSDictionaryMap<String, Object>>(map, dp, this.stream, COSName.DECODE_PARMS);
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap<String, Object>> actuals = new ArrayList<COSDictionaryMap<String, Object>>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setDecodeParms(List<?> decodeParams) {
        this.stream.setItem(COSName.DECODE_PARMS, (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    public PDFileSpecification getFile() throws IOException {
        COSBase f = this.stream.getDictionaryObject(COSName.F);
        return PDFileSpecification.createFS(f);
    }

    public void setFile(PDFileSpecification f) {
        this.stream.setItem(COSName.F, (COSObjectable)f);
    }

    public List<String> getFileFilters() {
        List<String> retval = null;
        COSBase filters = this.stream.getDictionaryObject(COSName.F_FILTER);
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList<String>(name.getName(), name, this.stream, COSName.F_FILTER);
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFileFilters(List<String> filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.stream.setItem(COSName.F_FILTER, (COSBase)obj);
    }

    public List<Object> getFileDecodeParams() throws IOException {
        COSArrayList<COSDictionaryMap<String, Object>> retval = null;
        COSBase dp = this.stream.getDictionaryObject(COSName.F_DECODE_PARMS);
        if (dp instanceof COSDictionary) {
            COSDictionaryMap<String, Object> map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList<COSDictionaryMap<String, Object>>(map, dp, this.stream, COSName.F_DECODE_PARMS);
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap<String, Object>> actuals = new ArrayList<COSDictionaryMap<String, Object>>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setFileDecodeParams(List<?> decodeParams) {
        this.stream.setItem("FDecodeParams", (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try (COSInputStream is = null;){
            int amountRead;
            is = this.createInputStream();
            while ((amountRead = ((InputStream)is).read(buf)) != -1) {
                output.write(buf, 0, amountRead);
            }
        }
        return output.toByteArray();
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSBase mdStream = this.stream.getDictionaryObject(COSName.METADATA);
        if (mdStream != null) {
            if (mdStream instanceof COSStream) {
                retval = new PDMetadata((COSStream)mdStream);
            } else if (!(mdStream instanceof COSNull)) {
                throw new IllegalStateException("Expected a COSStream but was a " + mdStream.getClass().getSimpleName());
            }
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.stream.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getDecodedStreamLength() {
        return this.stream.getInt(COSName.DL);
    }

    public void setDecodedStreamLength(int decodedStreamLength) {
        this.stream.setInt(COSName.DL, decodedStreamLength);
    }
}

