/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.fsutil;

import com.ahsay.ani.util.FileUtil;
import java.io.File;

public class FileSystemStat {
    protected static final boolean LOAD_NATIVE = true;
    public static final long PATH_NOT_EXIST_SIZE = 0L;
    public static final long UNSUPPORTED_SIZE = 0x20000000000L;
    protected static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.ahsay.ani.fsutil.FileSystemStat.debug"));

    public long getFreeSpace(String string) {
        File file = new File(string);
        if (!FileUtil.exists(file)) {
            return 0L;
        }
        if (DEBUG) {
            System.out.println("[FileSystemStat.getFreeSpace][Start] sPath=" + string);
        }
        long l = file.getFreeSpace();
        if (DEBUG) {
            System.out.println("[FileSystemStat.getFreeSpace][End] lFreeSpace=" + l);
        }
        return l;
    }

    public long getUsableSpace(String string) {
        File file = new File(string);
        if (!FileUtil.exists(file)) {
            return 0L;
        }
        if (DEBUG) {
            System.out.println("[FileSystemStat.getUsableSpace][Start] sPath=" + string);
        }
        long l = file.getUsableSpace();
        if (DEBUG) {
            System.out.println("[FileSystemStat.getUsableSpace][End] lFreeSpace=" + l);
        }
        return l;
    }

    public long getTotalSpace(String string) {
        File file = new File(string);
        if (!FileUtil.exists(file)) {
            return 0L;
        }
        if (DEBUG) {
            System.out.println("[FileSystemStat.getTotalSpace][Start] sPath=" + string);
        }
        long l = file.getTotalSpace();
        if (DEBUG) {
            System.out.println("[FileSystemStat.getTotalSpace][End] lTotalSpace=" + l);
        }
        return l;
    }

    private FileSystemStat() {
    }

    public static FileSystemStat getInstance() {
        return new FileSystemStat();
    }

    public static void main(String[] stringArray) {
        try {
            FileSystemStat fileSystemStat = FileSystemStat.getInstance();
            long l = fileSystemStat.getUsableSpace(stringArray[0]);
            System.out.println("Free space for " + stringArray[0] + " = " + l);
            long l2 = fileSystemStat.getTotalSpace(stringArray[0]);
            System.out.println("Total space for " + stringArray[0] + " = " + l2);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

