/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider.buypass;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.provider.AbstractAcmeProvider;

public class BuypassAcmeProvider
extends AbstractAcmeProvider {
    private static final String PRODUCTION_DIRECTORY_URL = "https://api.buypass.com/acme/directory";
    private static final String STAGING_DIRECTORY_URL = "https://api.test4.buypass.no/acme/directory";

    @Override
    public boolean accepts(URI serverUri) {
        return "acme".equals(serverUri.getScheme()) && "buypass.com".equals(serverUri.getHost());
    }

    @Override
    public URL resolve(URI serverUri) {
        String directoryUrl;
        String path = serverUri.getPath();
        if (path == null || path.isEmpty() || "/".equals(path)) {
            directoryUrl = PRODUCTION_DIRECTORY_URL;
        } else if ("/staging".equals(path)) {
            directoryUrl = STAGING_DIRECTORY_URL;
        } else {
            throw new IllegalArgumentException("Unknown URI " + String.valueOf(serverUri));
        }
        try {
            return new URL(directoryUrl);
        }
        catch (MalformedURLException ex) {
            throw new AcmeProtocolException(directoryUrl, ex);
        }
    }
}

