/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.challenge;

import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.challenge.TokenChallenge;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.util.CertificateUtils;

public class TlsAlpn01Challenge
extends TokenChallenge {
    private static final long serialVersionUID = -5590351078176091228L;
    public static final String TYPE = "tls-alpn-01";
    public static final String ACME_VALIDATION_OID = "1.3.6.1.5.5.7.1.31";
    public static final String ACME_TLS_1_PROTOCOL = "acme-tls/1";

    public TlsAlpn01Challenge(Login login, JSON data) {
        super(login, data);
    }

    public byte[] getAcmeValidation() {
        return AcmeUtils.sha256hash(this.getAuthorization());
    }

    public X509Certificate createCertificate(KeyPair keypair, Identifier id) {
        try {
            return CertificateUtils.createTlsAlpn01Certificate(keypair, id, this.getAcmeValidation());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Bad certificate parameters", ex);
        }
    }

    @Override
    protected boolean acceptable(String type) {
        return TYPE.equals(type);
    }
}

