/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.TextProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class EnumProperty
extends TextProperty {
    protected EnumProperty(String value) {
        super(value);
    }

    protected EnumProperty(EnumProperty original) {
        super(original);
    }

    protected boolean is(String value) {
        return value.equalsIgnoreCase((String)this.value);
    }

    protected abstract Collection<String> getStandardValues(ICalVersion var1);

    protected Collection<ICalVersion> getValueSupportedVersions() {
        return this.value == null ? Collections.emptyList() : Arrays.asList(ICalVersion.values());
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        super.validate(components, version, warnings);
        if (this.value == null) {
            return;
        }
        Collection<ICalVersion> supportedVersions = this.getValueSupportedVersions();
        if (supportedVersions.isEmpty()) {
            warnings.add(new ValidationWarning(28, this.value, this.getStandardValues(version)));
            return;
        }
        boolean supported = supportedVersions.contains((Object)version);
        if (!supported) {
            warnings.add(new ValidationWarning(46, this.value, supportedVersions));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + (this.value == null ? 0 : ((String)this.value).toLowerCase().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumProperty other = (EnumProperty)obj;
        if (!this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !((String)this.value).equalsIgnoreCase((String)other.value));
    }
}

