/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.Encoding;
import biweekly.parameter.ICalParameters;
import biweekly.property.BinaryProperty;
import biweekly.property.ICalProperty;
import biweekly.util.org.apache.commons.codec.binary.Base64;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

public abstract class BinaryPropertyScribe<T extends BinaryProperty>
extends ICalPropertyScribe<T> {
    protected BinaryPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.URI);
    }

    @Override
    protected ICalParameters _prepareParameters(T property, WriteContext context) {
        ICalParameters copy = new ICalParameters(((ICalProperty)property).getParameters());
        if (((BinaryProperty)property).getUri() != null) {
            copy.setEncoding(null);
        } else if (((BinaryProperty)property).getData() != null) {
            copy.setEncoding(Encoding.BASE64);
        }
        return copy;
    }

    @Override
    protected ICalDataType _dataType(T property, ICalVersion version) {
        if (((BinaryProperty)property).getUri() != null) {
            return version == ICalVersion.V1_0 ? ICalDataType.URL : ICalDataType.URI;
        }
        if (((BinaryProperty)property).getData() != null) {
            return ICalDataType.BINARY;
        }
        return this.defaultDataType(version);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        String uri = ((BinaryProperty)property).getUri();
        if (uri != null) {
            return uri;
        }
        byte[] data = ((BinaryProperty)property).getData();
        if (data != null) {
            return Base64.encodeBase64String(data);
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape((String)value);
        if (dataType == ICalDataType.BINARY || parameters.getEncoding() == Encoding.BASE64) {
            byte[] data = Base64.decodeBase64(value);
            return this.newInstance(data);
        }
        return this.newInstance(value, dataType);
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        String uri = ((BinaryProperty)property).getUri();
        if (uri != null) {
            element.append(ICalDataType.URI, uri);
            return;
        }
        byte[] data = ((BinaryProperty)property).getData();
        if (data != null) {
            element.append(ICalDataType.BINARY, Base64.encodeBase64String(data));
            return;
        }
        element.append(this.defaultDataType(context.getVersion()), "");
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String uri = element.first(ICalDataType.URI);
        if (uri != null) {
            return this.newInstance(uri, ICalDataType.URI);
        }
        String base64Data = element.first(ICalDataType.BINARY);
        if (base64Data != null) {
            byte[] data = Base64.decodeBase64(base64Data);
            return this.newInstance(data);
        }
        throw BinaryPropertyScribe.missingXmlElements(ICalDataType.URI, ICalDataType.BINARY);
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        String uri = ((BinaryProperty)property).getUri();
        if (uri != null) {
            return JCalValue.single(uri);
        }
        byte[] data = ((BinaryProperty)property).getData();
        if (data != null) {
            return JCalValue.single(Base64.encodeBase64String(data));
        }
        return JCalValue.single("");
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        if (dataType == ICalDataType.BINARY) {
            byte[] data = Base64.decodeBase64(valueStr);
            return this.newInstance(data);
        }
        return this.newInstance(valueStr, dataType);
    }

    protected abstract T newInstance(byte[] var1);

    protected abstract T newInstance(String var1, ICalDataType var2);
}

