/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.EnforcementMode;
import com.azure.resourcemanager.resources.models.NonComplianceMessage;
import com.azure.resourcemanager.resources.models.ParameterValuesValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class PolicyAssignmentProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PolicyAssignmentProperties.class);
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="policyDefinitionId")
    private String policyDefinitionId;
    @JsonProperty(value="scope", access=JsonProperty.Access.WRITE_ONLY)
    private String scope;
    @JsonProperty(value="notScopes")
    private List<String> notScopes;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, ParameterValuesValue> parameters;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="metadata")
    private Object metadata;
    @JsonProperty(value="enforcementMode")
    private EnforcementMode enforcementMode;
    @JsonProperty(value="nonComplianceMessages")
    private List<NonComplianceMessage> nonComplianceMessages;

    public String displayName() {
        return this.displayName;
    }

    public PolicyAssignmentProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public PolicyAssignmentProperties withPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public List<String> notScopes() {
        return this.notScopes;
    }

    public PolicyAssignmentProperties withNotScopes(List<String> notScopes) {
        this.notScopes = notScopes;
        return this;
    }

    public Map<String, ParameterValuesValue> parameters() {
        return this.parameters;
    }

    public PolicyAssignmentProperties withParameters(Map<String, ParameterValuesValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicyAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public PolicyAssignmentProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public EnforcementMode enforcementMode() {
        return this.enforcementMode;
    }

    public PolicyAssignmentProperties withEnforcementMode(EnforcementMode enforcementMode) {
        this.enforcementMode = enforcementMode;
        return this;
    }

    public List<NonComplianceMessage> nonComplianceMessages() {
        return this.nonComplianceMessages;
    }

    public PolicyAssignmentProperties withNonComplianceMessages(List<NonComplianceMessage> nonComplianceMessages) {
        this.nonComplianceMessages = nonComplianceMessages;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.nonComplianceMessages() != null) {
            this.nonComplianceMessages().forEach(e -> e.validate());
        }
    }
}

