/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.search.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.azure.resourcemanager.search.models.HostingMode;
import com.azure.resourcemanager.search.models.Identity;
import com.azure.resourcemanager.search.models.NetworkRuleSet;
import com.azure.resourcemanager.search.models.ProvisioningState;
import com.azure.resourcemanager.search.models.PublicNetworkAccess;
import com.azure.resourcemanager.search.models.SearchServiceStatus;
import com.azure.resourcemanager.search.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class SearchServiceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SearchServiceInner.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="properties.replicaCount")
    private Integer replicaCount;
    @JsonProperty(value="properties.partitionCount")
    private Integer partitionCount;
    @JsonProperty(value="properties.hostingMode")
    private HostingMode hostingMode;
    @JsonProperty(value="properties.publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="properties.status", access=JsonProperty.Access.WRITE_ONLY)
    private SearchServiceStatus status;
    @JsonProperty(value="properties.statusDetails", access=JsonProperty.Access.WRITE_ONLY)
    private String statusDetails;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.networkRuleSet")
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="properties.privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="properties.sharedPrivateLinkResources", access=JsonProperty.Access.WRITE_ONLY)
    private List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources;

    public Sku sku() {
        return this.sku;
    }

    public SearchServiceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public SearchServiceInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public SearchServiceInner withReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
        return this;
    }

    public Integer partitionCount() {
        return this.partitionCount;
    }

    public SearchServiceInner withPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    public HostingMode hostingMode() {
        return this.hostingMode;
    }

    public SearchServiceInner withHostingMode(HostingMode hostingMode) {
        this.hostingMode = hostingMode;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public SearchServiceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public SearchServiceStatus status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public SearchServiceInner withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources() {
        return this.sharedPrivateLinkResources;
    }

    public SearchServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SearchServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.sharedPrivateLinkResources() != null) {
            this.sharedPrivateLinkResources().forEach(e -> e.validate());
        }
    }
}

