/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.azure.resourcemanager.search.fluent.SearchManagementClient;
import com.azure.resourcemanager.search.implementation.SearchManagementClientBuilder;
import com.azure.resourcemanager.search.implementation.SearchServicesImpl;
import com.azure.resourcemanager.search.models.SearchServices;

public final class SearchServiceManager
extends Manager<SearchManagementClient> {
    private SearchServices searchServices;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static SearchServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
        return SearchServiceManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static SearchServiceManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new SearchServiceManager(httpPipeline, profile);
    }

    private SearchServiceManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new SearchManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public SearchServices searchServices() {
        if (this.searchServices == null) {
            this.searchServices = new SearchServicesImpl(this);
        }
        return this.searchServices;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public SearchServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
            return SearchServiceManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public SearchServiceManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

