/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.util;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.ActionSource2;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.MethodExpressionActionListener;
import java.util.Map;

public class Utils {
    private Utils() {
    }

    public static void setBooleanProperty(UIComponent component, String propName, ValueExpression value) {
        Utils.setBooleanProperty(component, propName, value, null);
    }

    public static void setBooleanProperty(UIComponent component, String propName, ValueExpression value, Boolean defaultValue) {
        if (value == null) {
            if (defaultValue != null) {
                component.getAttributes().put(propName, defaultValue);
            }
            return;
        }
        if (value.isLiteralText()) {
            component.getAttributes().put(propName, Boolean.valueOf(value.getExpressionString()));
        } else {
            component.setValueExpression(propName, value);
        }
    }

    public static void setStringProperty(UIComponent component, String propName, ValueExpression value) {
        Utils.setStringProperty(component, propName, value, null);
    }

    public static void setStringProperty(UIComponent component, String propName, ValueExpression value, String defaultValue) {
        if (value == null) {
            if (defaultValue != null) {
                component.getAttributes().put(propName, defaultValue);
            }
            return;
        }
        if (value.isLiteralText()) {
            component.getAttributes().put(propName, value.getExpressionString());
        } else {
            component.setValueExpression(propName, value);
        }
    }

    public static void setIntegerProperty(UIComponent component, String propName, ValueExpression value) {
        Utils.setIntegerProperty(component, propName, value, null);
    }

    public static void setIntegerProperty(UIComponent component, String propName, ValueExpression value, Integer defaultValue) {
        if (value == null) {
            if (defaultValue != null) {
                component.getAttributes().put(propName, defaultValue);
            }
            return;
        }
        if (value.isLiteralText()) {
            component.getAttributes().put(propName, Integer.valueOf(value.getExpressionString()));
        } else {
            component.setValueExpression(propName, value);
        }
    }

    public static void setActionProperty(UIComponent component, MethodExpression action) {
        if (action != null) {
            Utils.castActionSource2(component).setActionExpression(action);
        }
    }

    public static void setActionListenerProperty(UIComponent component, MethodExpression actionListener) {
        if (actionListener != null) {
            Utils.castActionSource2(component).addActionListener((ActionListener)new MethodExpressionActionListener(actionListener));
        }
    }

    private static ActionSource2 castActionSource2(UIComponent component) {
        if (component instanceof ActionSource2) {
            return (ActionSource2)component;
        }
        throw new IllegalArgumentException("Component " + component.getClientId() + " is no ActionSource2");
    }

    public static <T> T getMapValue(Class<T> clazz, Map<String, Object> map, String key) {
        Object ret = map.get(key);
        return clazz.cast(ret);
    }
}

