/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Map;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.faces.component.FormComponent;
import org.apache.struts.faces.renderer.AbstractRenderer;
import org.apache.struts.faces.util.StrutsContext;
import org.apache.struts.faces.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormRenderer
extends AbstractRenderer {
    private final Logger log = LoggerFactory.getLogger(FormRenderer.class);
    private static String[] passThrough = new String[]{"enctype", "method", "onreset", "onsubmit", "style", "target"};

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String clientId = component.getClientId(context);
        Map map = context.getExternalContext().getRequestParameterMap();
        this.log.atDebug().setMessage("decode({}) --> {}").addArgument((Object)clientId).addArgument(() -> map.containsKey(clientId)).log();
        component.getAttributes().put("submitted", map.containsKey(clientId) ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String token;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        FormComponent form = (FormComponent)component;
        String action = form.getAction();
        ModuleConfig moduleConfig = StrutsContext.getModuleConfig(context);
        ActionConfig actionConfig = moduleConfig.findActionConfig(action);
        if (actionConfig == null) {
            throw new IllegalArgumentException("Cannot find action '" + action + "' configuration");
        }
        String beanName = actionConfig.getAttribute();
        if (beanName != null) {
            form.getAttributes().put("beanName", beanName);
        }
        String clientId = component.getClientId(context);
        this.log.debug("encodeBegin({})", (Object)clientId);
        String styleClass = Utils.getMapValue(String.class, component.getAttributes(), "styleClass");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("form", (UIComponent)form);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        if (beanName != null) {
            writer.writeAttribute("name", (Object)beanName, null);
        }
        writer.writeAttribute("action", (Object)this.action(context, component), "action");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (component.getAttributes().get("method") == null) {
            writer.writeAttribute("method", (Object)"post", null);
        }
        this.renderPassThrough(context, component, writer, passThrough);
        writer.writeText((Object)"\n", null);
        writer.startElement("input", (UIComponent)form);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("value", (Object)clientId, null);
        writer.endElement("input");
        writer.writeText((Object)"\n", null);
        HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
        if (session != null && (token = (String)session.getAttribute("org.apache.struts.action.TOKEN")) != null) {
            writer.startElement("input", (UIComponent)form);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)"org.apache.struts.taglib.html.TOKEN", null);
            writer.writeAttribute("value", (Object)token, null);
            writer.endElement("input");
            writer.writeText((Object)"\n", null);
        }
        if (component instanceof FormComponent) {
            ((FormComponent)component).createActionForm(context);
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String clientId = component.getClientId(context);
        this.log.debug("encodeEnd({})", (Object)clientId);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)component.getClientId(context), null);
        writer.writeAttribute("value", (Object)component.getClientId(context), null);
        writer.endElement("input");
        writer.write("\n");
        context.getApplication().getViewHandler().writeState(context);
        writer.endElement("form");
        writer.writeText((Object)"\n", null);
        if (!(component instanceof FormComponent)) {
            return;
        }
        String focus = (String)component.getAttributes().get("focus");
        if (focus == null) {
            return;
        }
        String focusIndex = (String)component.getAttributes().get("focusIndex");
        writer.writeText((Object)"\n", null);
        FormComponent form = (FormComponent)component;
        writer.startElement("script", (UIComponent)form);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (!this.isXhtml(component)) {
            writer.writeAttribute("language", (Object)"JavaScript", null);
        }
        writer.writeText((Object)"\n", null);
        StringBuilder sb = new StringBuilder("document.forms[\"");
        sb.append(clientId);
        sb.append("\"].elements[\"");
        sb.append(component.getClientId(context));
        sb.append(UINamingContainer.getSeparatorChar((FacesContext)context));
        sb.append(focus);
        sb.append("\"]");
        String focusControl = sb.toString();
        writer.write("  var focusControl = ");
        writer.write(focusControl);
        writer.write(";\n");
        writer.write("  if (focusControl.type != \"hidden\") {\n");
        writer.write("    ");
        writer.write(focusControl);
        if (focusIndex != null) {
            writer.write("[");
            writer.write(focusIndex);
            writer.write("]");
        }
        writer.write(".focus();\n");
        writer.write("  }\n");
        writer.endElement("script");
        writer.writeText((Object)"\n", null);
    }

    protected String action(FacesContext context, UIComponent component) {
        String actionURL = context.getApplication().getViewHandler().getActionURL(context, context.getViewRoot().getViewId());
        this.log.trace("getActionURL({}) --> {}", (Object)context.getViewRoot().getViewId(), (Object)actionURL);
        return context.getExternalContext().encodeActionURL(actionURL);
    }
}

