/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.beans.Beans;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.faces.renderer.AbstractRenderer;
import org.apache.struts.util.MessageResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorsRenderer
extends AbstractRenderer {
    private final Logger log = LoggerFactory.getLogger(ErrorsRenderer.class);
    protected static MessageResources dummy = MessageResources.getMessageResources((String)"org.apache.struts.faces.renderer.Dummy");

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        this.log.debug("encodeEnd() started");
        MessageResources resources = this.resources(context, component);
        if (Beans.isDesignTime() && resources == null) {
            resources = dummy;
        }
        Locale locale = context.getViewRoot().getLocale();
        boolean headerPresent = resources.isPresent(locale, "errors.header");
        boolean footerPresent = resources.isPresent(locale, "errors.footer");
        boolean prefixPresent = resources.isPresent(locale, "errors.prefix");
        boolean suffixPresent = resources.isPresent(locale, "errors.suffix");
        boolean headerDone = false;
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getId();
        String property = (String)component.getAttributes().get("property");
        if (id != null) {
            writer.startElement("span", component);
            if (id != null) {
                writer.writeAttribute("id", (Object)component.getClientId(context), "id");
            }
        }
        Iterator messages = context.getMessages(property);
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            this.log.trace("Processing FacesMessage: {}", (Object)message.getSummary());
            if (!headerDone) {
                if (headerPresent) {
                    writer.write(resources.getMessage(locale, "errors.header"));
                }
                headerDone = true;
            }
            if (prefixPresent) {
                writer.write(resources.getMessage(locale, "errors.prefix"));
            }
            writer.write(message.getSummary());
            if (!suffixPresent) continue;
            writer.write(resources.getMessage(locale, "errors.suffix"));
        }
        ActionMessages errors = (ActionMessages)context.getExternalContext().getRequestMap().get("org.apache.struts.action.ERROR");
        if (errors != null) {
            this.log.trace("Processing Struts messages for property '{}'", (Object)property);
            Iterator reports = null;
            reports = property == null ? errors.get() : errors.get(property);
            while (reports.hasNext()) {
                ActionMessage report = (ActionMessage)reports.next();
                this.log.trace("Processing Struts message key='{}'", (Object)report.getKey());
                if (!headerDone) {
                    writer = context.getResponseWriter();
                    if (headerPresent) {
                        writer.write(resources.getMessage(locale, "errors.header"));
                    }
                    headerDone = true;
                }
                if (prefixPresent) {
                    writer.write(resources.getMessage(locale, "errors.prefix"));
                }
                writer.write(resources.getMessage(locale, report.getKey(), report.getValues()));
                if (!suffixPresent) continue;
                writer.write(resources.getMessage(locale, "errors.suffix"));
            }
        }
        if (headerDone && footerPresent) {
            writer.write(resources.getMessage(locale, "errors.footer"));
        }
        if (id != null) {
            writer.endElement("span");
        }
        this.log.debug("encodeEnd() finished");
    }

    protected MessageResources resources(FacesContext context, UIComponent component) {
        String bundle = (String)component.getAttributes().get("bundle");
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        return (MessageResources)context.getExternalContext().getApplicationMap().get(bundle);
    }
}

