/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import jakarta.el.ValueExpression;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.struts.faces.component.HtmlComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderer
extends Renderer {
    private final Logger log = LoggerFactory.getLogger(AbstractRenderer.class);

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        if (component instanceof EditableValueHolder) {
            this.setSubmittedValue(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        this.log.trace("encodeBegin(id={}, family={}, rendererType={})", new Object[]{component.getId(), component.getFamily(), component.getRendererType()});
        ResponseWriter writer = context.getResponseWriter();
        this.renderStart(context, component, writer);
        this.renderAttributes(context, component, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        this.log.trace("encodeChildren(id={}, family={}, rendererType={})", new Object[]{component.getId(), component.getFamily(), component.getRendererType()});
        List kids = component.getChildren();
        for (UIComponent kid : kids) {
            kid.encodeBegin(context);
            if (kid.getRendersChildren()) {
                kid.encodeChildren(context);
            }
            kid.encodeEnd(context);
        }
        this.log.trace("encodeChildren(id={}) end", (Object)component.getId());
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        this.log.trace("encodeEnd(id={}, family={}, rendererType={})", new Object[]{component.getId(), component.getFamily(), component.getRendererType()});
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnd(context, component, writer);
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        this.log.trace("encodeRecursive(id={}, family={}, rendererType={}) encodeBegin", new Object[]{component.getId(), component.getFamily(), component.getRendererType()});
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            this.log.trace("encodeRecursive(id={}) delegating", (Object)component.getId());
            component.encodeChildren(context);
        } else {
            this.log.trace("encodeRecursive(id={}) recursing", (Object)component.getId());
            List kids = component.getChildren();
            for (UIComponent kid : kids) {
                this.encodeRecursive(context, kid);
            }
        }
        this.log.trace("encodeRecursive(id={}) encodeEnd", (Object)component.getId());
        component.encodeEnd(context);
    }

    protected boolean isDisabled(UIComponent component) {
        Object disabled = component.getAttributes().get("disabled");
        if (disabled == null) {
            return false;
        }
        if (disabled instanceof String) {
            return Boolean.valueOf((String)disabled);
        }
        return disabled.equals(Boolean.TRUE);
    }

    protected boolean isReadOnly(UIComponent component) {
        Object readonly = component.getAttributes().get("readonly");
        if (readonly == null) {
            return false;
        }
        if (readonly instanceof String) {
            return Boolean.valueOf((String)readonly);
        }
        return readonly.equals(Boolean.TRUE);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderBoolean(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (String name : names) {
            boolean flag;
            Object value = attributes.get(name);
            if (value == null || !(flag = value instanceof String ? Boolean.valueOf((String)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue())) continue;
            writer.writeAttribute(name, (Object)name, name);
            flag = false;
        }
    }

    protected void renderPassThrough(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (String name : names) {
            Object value = attributes.get(name);
            if (value == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(name, value, name);
                continue;
            }
            writer.writeAttribute(name, (Object)value.toString(), name);
        }
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void setSubmittedValue(FacesContext context, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map parameters = context.getExternalContext().getRequestParameterMap();
        if (parameters.containsKey(clientId)) {
            this.log.atTrace().setMessage("setSubmittedValue({},{})").addArgument((Object)clientId).addArgument(() -> parameters.get(clientId)).log();
            component.getAttributes().put("submittedValue", parameters.get(clientId));
        }
    }

    protected String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        Class type;
        ValueExpression vb = component.getValueExpression("value");
        Converter converter = null;
        if (component instanceof ValueHolder) {
            Converter conv;
            converter = conv = ((ValueHolder)component).getConverter();
        }
        if (converter == null && vb != null && (type = vb.getType(context.getELContext())) != null) {
            Converter conv;
            converter = conv = context.getApplication().createConverter(type);
        }
        if (converter != null) {
            return converter.getAsString(context, component, value);
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    protected boolean isXhtml(UIComponent component) {
        HtmlComponent htmlComponent = this.searchComponent(HtmlComponent.class, component);
        return htmlComponent == null ? false : htmlComponent.isXhtml();
    }

    protected <T extends UIComponent> T searchComponent(Class<T> clazz, UIComponent component) {
        while (component != null) {
            if (clazz.isInstance(component)) {
                return (T)((UIComponent)clazz.cast(component));
            }
            component = component.getParent();
        }
        return null;
    }
}

