/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.application;

import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UICommand;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.faces.component.FormComponent;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacesTilesRequestProcessor
extends TilesRequestProcessor {
    private static final long serialVersionUID = -762245366421871701L;
    private final transient Logger log = LoggerFactory.getLogger(FacesTilesRequestProcessor.class);
    public static final String LIFECYCLE_ID_ATTR = "jakarta.faces.LIFECYCLE_ID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doForward(" + uri + ")");
        }
        request.removeAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (this.isStrutsRequest(uri)) {
            if (response.isCommitted()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("  super.doInclude(" + uri + ")");
                }
                super.doInclude(uri, request, response);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("  super.doForward(" + uri + ")");
                }
                super.doForward(uri, request, response);
            }
            return;
        }
        LifecycleFactory lf = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lf.getLifecycle(this.getLifecycleId());
        boolean created = false;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("  Creating new FacesContext for '" + uri + "'");
            }
            created = true;
            FacesContextFactory fcf = (FacesContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.FacesContextFactory");
            context = fcf.getFacesContext((Object)this.servlet.getServletContext(), (Object)request, (Object)response, lifecycle);
        }
        ViewHandler vh = context.getApplication().getViewHandler();
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Creating new view for '" + uri + "'");
        }
        context.setViewRoot(vh.createView(context, uri));
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Rendering view for '" + uri + "'");
        }
        try {
            lifecycle.render(context);
        }
        finally {
            if (created) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("  Releasing context for '" + uri + "'");
                }
                context.release();
            } else if (this.log.isTraceEnabled()) {
                this.log.trace("  Rendering completed");
            }
        }
    }

    protected void internalModuleRelativeForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing internal module relative forward to '" + uri + "'");
        }
        super.internalModuleRelativeForward(uri, request, response);
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing standard action create");
        }
        Action result = super.processActionCreate(request, response, mapping);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Standard action create returned " + result.getClass().getName() + " instance");
        }
        return result;
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing standard action form processing");
            String attribute = mapping.getAttribute();
            if (attribute != null) {
                String name = mapping.getName();
                FormBeanConfig fbc = this.moduleConfig.findFormBeanConfig(name);
                if (fbc != null) {
                    if ("request".equals(mapping.getScope())) {
                        this.log.trace("  Bean in request scope = " + request.getAttribute(attribute));
                    } else {
                        this.log.trace("  Bean in session scope = " + request.getSession().getAttribute(attribute));
                    }
                } else {
                    this.log.trace("  No FormBeanConfig for '" + name + "'");
                }
            } else {
                this.log.trace("  No form bean for this action");
            }
        }
        ActionForm result = super.processActionForm(request, response, mapping);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Standard action form returned " + result);
        }
        return result;
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing standard action perform");
        }
        ActionForward result = super.processActionPerform(request, response, action, form, mapping);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Standard action perform returned " + (result == null ? "NULL" : result.getPath()) + " forward path");
        }
        return result;
    }

    protected boolean processForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing standard forward handling");
        }
        boolean result = super.processForward(request, response, mapping);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Standard forward handling returned " + result);
        }
        return result;
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing standard forward config handling");
        }
        super.processForwardConfig(request, response, forward);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Standard forward config handling completed");
        }
    }

    protected boolean processInclude(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing standard include handling");
        }
        boolean result = super.processInclude(request, response, mapping);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Standard include handling returned " + result);
        }
        return result;
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ActionEvent event = (ActionEvent)request.getAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (event == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Performing standard processPath() processing");
            }
            return super.processPath(request, response);
        }
        UIComponent component = event.getComponent();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Locating form parent for command component " + event.getComponent());
        }
        while (!(component instanceof FormComponent)) {
            if ((component = component.getParent()) != null) continue;
            this.log.warn("Command component was not nested in a Struts form!");
            return null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Returning selected path of " + ((FormComponent)component).getAction());
        }
        return ((FormComponent)component).getAction();
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        UIComponent source;
        ActionEvent event = (ActionEvent)request.getAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (event == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Performing standard processPopulate() processing");
            }
            super.processPopulate(request, response, form, mapping);
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Faces request, so no processPopulate() processing");
        }
        if ((source = event.getComponent()) instanceof UICommand && "cancel".equals(((UICommand)source).getId())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Faces request with cancel button pressed");
            }
            request.setAttribute("org.apache.struts.action.CANCEL", (Object)Boolean.TRUE);
        }
    }

    protected boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException, InvalidCancelException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing standard validation");
        }
        boolean result = super.processValidate(request, response, form, mapping);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Standard validation processing returned " + result);
        }
        return result;
    }

    private String getLifecycleId() {
        String lifecycleId = this.servlet.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
        return lifecycleId != null ? lifecycleId : "DEFAULT";
    }

    private boolean isStrutsRequest(String uri) {
        String mapping;
        int question = uri.indexOf("?");
        if (question >= 0) {
            uri = uri.substring(0, question);
        }
        if ((mapping = (String)this.servlet.getServletContext().getAttribute("org.apache.struts.action.SERVLET_MAPPING")) == null) {
            return false;
        }
        if (mapping.startsWith("*.")) {
            return uri.endsWith(mapping.substring(1));
        }
        if (mapping.endsWith("/*")) {
            return uri.startsWith(mapping.substring(0, mapping.length() - 2));
        }
        return false;
    }
}

