/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.application;

import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UICommand;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.faces.component.FormComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacesRequestProcessor
extends RequestProcessor {
    private static final long serialVersionUID = 4303368318034722173L;
    private final transient Logger log = LoggerFactory.getLogger(FacesRequestProcessor.class);
    public static final String LIFECYCLE_ID_ATTR = "jakarta.faces.LIFECYCLE_ID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.log.debug("doForward({})", (Object)uri);
        request.removeAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (this.isStrutsRequest(uri)) {
            if (response.isCommitted()) {
                this.log.trace("  super.doInclude({})", (Object)uri);
                super.doInclude(uri, request, response);
            } else {
                this.log.trace("  super.doForward({})", (Object)uri);
                super.doForward(uri, request, response);
            }
            return;
        }
        LifecycleFactory lf = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lf.getLifecycle(this.getLifecycleId());
        boolean created = false;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            this.log.trace("  Creating new FacesContext for '{}'", (Object)uri);
            created = true;
            FacesContextFactory fcf = (FacesContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.FacesContextFactory");
            context = fcf.getFacesContext((Object)this.servlet.getServletContext(), (Object)request, (Object)response, lifecycle);
        }
        ViewHandler vh = context.getApplication().getViewHandler();
        this.log.trace("  Creating new view for '{}'", (Object)uri);
        context.setViewRoot(vh.createView(context, uri));
        this.log.trace("  Rendering view for '{}'", (Object)uri);
        try {
            lifecycle.render(context);
        }
        finally {
            if (created) {
                this.log.trace("  Releasing context for '{}'", (Object)uri);
                context.release();
            } else {
                this.log.trace("  Rendering completed");
            }
        }
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        this.log.trace("Performing standard action create");
        Action result = super.processActionCreate(request, response, mapping);
        this.log.debug("Standard action create returned {} instance", (Object)result.getClass().getName());
        return result;
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Performing standard action form processing");
            String attribute = mapping.getAttribute();
            if (attribute != null) {
                String name = mapping.getName();
                FormBeanConfig fbc = this.moduleConfig.findFormBeanConfig(name);
                if (fbc != null) {
                    if ("request".equals(mapping.getScope())) {
                        this.log.trace("  Bean in request scope = {}", request.getAttribute(attribute));
                    } else {
                        this.log.trace("  Bean in session scope = {}", request.getSession().getAttribute(attribute));
                    }
                } else {
                    this.log.trace("  No FormBeanConfig for '{}'", (Object)name);
                }
            } else {
                this.log.trace("  No form bean for this action");
            }
        }
        ActionForm result = super.processActionForm(request, response, mapping);
        this.log.debug("Standard action form returned {}", (Object)result);
        return result;
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        this.log.trace("Performing standard action perform");
        ActionForward result = super.processActionPerform(request, response, action, form, mapping);
        this.log.atDebug().setMessage("Standard action perform returned {} forward path").addArgument(() -> result == null ? "NULL" : result.getPath()).log();
        return result;
    }

    protected boolean processForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        this.log.trace("Performing standard forward handling");
        boolean result = super.processForward(request, response, mapping);
        this.log.debug("Standard forward handling returned {}", (Object)result);
        return result;
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        this.log.trace("Performing standard forward config handling");
        super.processForwardConfig(request, response, forward);
        this.log.debug("Standard forward config handling completed");
    }

    protected boolean processInclude(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        this.log.trace("Performing standard include handling");
        boolean result = super.processInclude(request, response, mapping);
        this.log.debug("Standard include handling returned {}", (Object)result);
        return result;
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ActionEvent event = (ActionEvent)request.getAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (event == null) {
            this.log.trace("Performing standard processPath() processing");
            return super.processPath(request, response);
        }
        UIComponent component = event.getComponent();
        this.log.trace("Locating form parent for command component {}", (Object)event.getComponent());
        while (!(component instanceof FormComponent)) {
            if ((component = component.getParent()) != null) continue;
            this.log.warn("Command component was not nested in a Struts form!");
            return null;
        }
        String action = ((FormComponent)component).getAction();
        this.log.debug("Returning selected path of '{}'", (Object)action);
        return action;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        ActionEvent event = (ActionEvent)request.getAttribute("org.apache.struts.faces.ACTION_EVENT");
        if (event == null) {
            this.log.trace("Performing standard processPopulate() processing");
            super.processPopulate(request, response, form, mapping);
            return;
        }
        this.log.trace("Faces request, so no processPopulate() processing");
        UIComponent source = event.getComponent();
        if (source instanceof UICommand && "cancel".equals(((UICommand)source).getId())) {
            this.log.trace("Faces request with cancel button pressed");
            request.setAttribute("org.apache.struts.action.CANCEL", (Object)Boolean.TRUE);
        }
    }

    protected boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException, InvalidCancelException {
        this.log.trace("Performing standard validation");
        boolean result = super.processValidate(request, response, form, mapping);
        this.log.debug("Standard validation processing returned {}", (Object)result);
        return result;
    }

    private String getLifecycleId() {
        String lifecycleId = this.servlet.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
        return lifecycleId != null ? lifecycleId : "DEFAULT";
    }

    private boolean isStrutsRequest(String uri) {
        String mapping;
        int question = uri.indexOf("?");
        if (question >= 0) {
            uri = uri.substring(0, question);
        }
        if ((mapping = (String)this.servlet.getServletContext().getAttribute("org.apache.struts.action.SERVLET_MAPPING")) == null) {
            return false;
        }
        if (mapping.startsWith("*.")) {
            return uri.endsWith(mapping.substring(1));
        }
        if (mapping.endsWith("/*")) {
            return uri.startsWith(mapping.substring(0, mapping.length() - 2));
        }
        return false;
    }
}

