/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardVersion;
import ezvcard.io.scribe.AddressScribe;
import ezvcard.io.scribe.AgentScribe;
import ezvcard.io.scribe.AnniversaryScribe;
import ezvcard.io.scribe.BirthdayScribe;
import ezvcard.io.scribe.BirthplaceScribe;
import ezvcard.io.scribe.CalendarRequestUriScribe;
import ezvcard.io.scribe.CalendarUriScribe;
import ezvcard.io.scribe.CategoriesScribe;
import ezvcard.io.scribe.ClassificationScribe;
import ezvcard.io.scribe.ClientPidMapScribe;
import ezvcard.io.scribe.DeathdateScribe;
import ezvcard.io.scribe.DeathplaceScribe;
import ezvcard.io.scribe.EmailScribe;
import ezvcard.io.scribe.ExpertiseScribe;
import ezvcard.io.scribe.FormattedNameScribe;
import ezvcard.io.scribe.FreeBusyUrlScribe;
import ezvcard.io.scribe.GenderScribe;
import ezvcard.io.scribe.GeoScribe;
import ezvcard.io.scribe.HobbyScribe;
import ezvcard.io.scribe.ImppScribe;
import ezvcard.io.scribe.InterestScribe;
import ezvcard.io.scribe.KeyScribe;
import ezvcard.io.scribe.KindScribe;
import ezvcard.io.scribe.LabelScribe;
import ezvcard.io.scribe.LanguageScribe;
import ezvcard.io.scribe.LogoScribe;
import ezvcard.io.scribe.MailerScribe;
import ezvcard.io.scribe.MemberScribe;
import ezvcard.io.scribe.NicknameScribe;
import ezvcard.io.scribe.NoteScribe;
import ezvcard.io.scribe.OrgDirectoryScribe;
import ezvcard.io.scribe.OrganizationScribe;
import ezvcard.io.scribe.PhotoScribe;
import ezvcard.io.scribe.ProductIdScribe;
import ezvcard.io.scribe.ProfileScribe;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.io.scribe.RelatedScribe;
import ezvcard.io.scribe.RevisionScribe;
import ezvcard.io.scribe.RoleScribe;
import ezvcard.io.scribe.SortStringScribe;
import ezvcard.io.scribe.SoundScribe;
import ezvcard.io.scribe.SourceDisplayTextScribe;
import ezvcard.io.scribe.SourceScribe;
import ezvcard.io.scribe.StructuredNameScribe;
import ezvcard.io.scribe.TelephoneScribe;
import ezvcard.io.scribe.TimezoneScribe;
import ezvcard.io.scribe.TitleScribe;
import ezvcard.io.scribe.UidScribe;
import ezvcard.io.scribe.UrlScribe;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.scribe.XmlScribe;
import ezvcard.property.RawProperty;
import ezvcard.property.VCardProperty;
import ezvcard.property.Xml;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class ScribeIndex {
    private static final Map<String, VCardPropertyScribe<? extends VCardProperty>> standardByName = new HashMap<String, VCardPropertyScribe<? extends VCardProperty>>();
    private static final Map<Class<? extends VCardProperty>, VCardPropertyScribe<? extends VCardProperty>> standardByClass = new HashMap<Class<? extends VCardProperty>, VCardPropertyScribe<? extends VCardProperty>>();
    private static final Map<QName, VCardPropertyScribe<? extends VCardProperty>> standardByQName = new HashMap<QName, VCardPropertyScribe<? extends VCardProperty>>();
    private final Map<String, VCardPropertyScribe<? extends VCardProperty>> extendedByName = new HashMap<String, VCardPropertyScribe<? extends VCardProperty>>(0);
    private final Map<Class<? extends VCardProperty>, VCardPropertyScribe<? extends VCardProperty>> extendedByClass = new HashMap<Class<? extends VCardProperty>, VCardPropertyScribe<? extends VCardProperty>>(0);
    private final Map<QName, VCardPropertyScribe<? extends VCardProperty>> extendedByQName = new HashMap<QName, VCardPropertyScribe<? extends VCardProperty>>(0);

    public VCardPropertyScribe<? extends VCardProperty> getPropertyScribe(String propertyName) {
        VCardPropertyScribe<? extends VCardProperty> scribe = this.extendedByName.get(propertyName = propertyName.toUpperCase());
        if (scribe != null) {
            return scribe;
        }
        return standardByName.get(propertyName);
    }

    public boolean hasPropertyScribe(VCardProperty property) {
        if (property instanceof RawProperty) {
            return true;
        }
        return this.getPropertyScribe(property.getClass()) != null;
    }

    public VCardPropertyScribe<? extends VCardProperty> getPropertyScribe(Class<? extends VCardProperty> clazz) {
        VCardPropertyScribe<? extends VCardProperty> scribe = this.extendedByClass.get(clazz);
        if (scribe != null) {
            return scribe;
        }
        return standardByClass.get(clazz);
    }

    public VCardPropertyScribe<? extends VCardProperty> getPropertyScribe(VCardProperty property) {
        if (property instanceof RawProperty) {
            RawProperty raw = (RawProperty)property;
            return new RawPropertyScribe(raw.getPropertyName());
        }
        return this.getPropertyScribe(property.getClass());
    }

    public VCardPropertyScribe<? extends VCardProperty> getPropertyScribe(QName qname) {
        VCardPropertyScribe<? extends VCardProperty> scribe = this.extendedByQName.get(qname);
        if (scribe != null) {
            return scribe;
        }
        scribe = standardByQName.get(qname);
        if (scribe != null) {
            return scribe;
        }
        if (VCardVersion.V4_0.getXmlNamespace().equals(qname.getNamespaceURI())) {
            return new RawPropertyScribe(qname.getLocalPart().toUpperCase());
        }
        return this.getPropertyScribe(Xml.class);
    }

    public void register(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.extendedByName.put(scribe.getPropertyName().toUpperCase(), scribe);
        this.extendedByClass.put(scribe.getPropertyClass(), scribe);
        this.extendedByQName.put(scribe.getQName(), scribe);
    }

    public void unregister(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.extendedByName.remove(scribe.getPropertyName().toUpperCase());
        this.extendedByClass.remove(scribe.getPropertyClass());
        this.extendedByQName.remove(scribe.getQName());
    }

    private static void registerStandard(VCardPropertyScribe<? extends VCardProperty> scribe) {
        standardByName.put(scribe.getPropertyName().toUpperCase(), scribe);
        standardByClass.put(scribe.getPropertyClass(), scribe);
        standardByQName.put(scribe.getQName(), scribe);
    }

    static {
        ScribeIndex.registerStandard(new AddressScribe());
        ScribeIndex.registerStandard(new AgentScribe());
        ScribeIndex.registerStandard(new AnniversaryScribe());
        ScribeIndex.registerStandard(new BirthdayScribe());
        ScribeIndex.registerStandard(new CalendarRequestUriScribe());
        ScribeIndex.registerStandard(new CalendarUriScribe());
        ScribeIndex.registerStandard(new CategoriesScribe());
        ScribeIndex.registerStandard(new ClassificationScribe());
        ScribeIndex.registerStandard(new ClientPidMapScribe());
        ScribeIndex.registerStandard(new EmailScribe());
        ScribeIndex.registerStandard(new FreeBusyUrlScribe());
        ScribeIndex.registerStandard(new FormattedNameScribe());
        ScribeIndex.registerStandard(new GenderScribe());
        ScribeIndex.registerStandard(new GeoScribe());
        ScribeIndex.registerStandard(new ImppScribe());
        ScribeIndex.registerStandard(new KeyScribe());
        ScribeIndex.registerStandard(new KindScribe());
        ScribeIndex.registerStandard(new LabelScribe());
        ScribeIndex.registerStandard(new LanguageScribe());
        ScribeIndex.registerStandard(new LogoScribe());
        ScribeIndex.registerStandard(new MailerScribe());
        ScribeIndex.registerStandard(new MemberScribe());
        ScribeIndex.registerStandard(new NicknameScribe());
        ScribeIndex.registerStandard(new NoteScribe());
        ScribeIndex.registerStandard(new OrganizationScribe());
        ScribeIndex.registerStandard(new PhotoScribe());
        ScribeIndex.registerStandard(new ProductIdScribe());
        ScribeIndex.registerStandard(new ProfileScribe());
        ScribeIndex.registerStandard(new RelatedScribe());
        ScribeIndex.registerStandard(new RevisionScribe());
        ScribeIndex.registerStandard(new RoleScribe());
        ScribeIndex.registerStandard(new SortStringScribe());
        ScribeIndex.registerStandard(new SoundScribe());
        ScribeIndex.registerStandard(new SourceDisplayTextScribe());
        ScribeIndex.registerStandard(new SourceScribe());
        ScribeIndex.registerStandard(new StructuredNameScribe());
        ScribeIndex.registerStandard(new TelephoneScribe());
        ScribeIndex.registerStandard(new TimezoneScribe());
        ScribeIndex.registerStandard(new TitleScribe());
        ScribeIndex.registerStandard(new UidScribe());
        ScribeIndex.registerStandard(new UrlScribe());
        ScribeIndex.registerStandard(new XmlScribe());
        ScribeIndex.registerStandard(new BirthplaceScribe());
        ScribeIndex.registerStandard(new DeathdateScribe());
        ScribeIndex.registerStandard(new DeathplaceScribe());
        ScribeIndex.registerStandard(new ExpertiseScribe());
        ScribeIndex.registerStandard(new OrgDirectoryScribe());
        ScribeIndex.registerStandard(new InterestScribe());
        ScribeIndex.registerStandard(new HobbyScribe());
    }
}

