/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.scripting;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.scripting.Script;
import org.apache.struts.scripting.ScriptContextFilter;
import org.apache.struts.scripting.StrutsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptAction
extends Action {
    private static final long serialVersionUID = -383996253054413439L;
    private static final Logger LOG = LoggerFactory.getLogger(ScriptAction.class);
    private static final ScriptEngineManager SCRIPT_ENGINE_MANAGER = new ScriptEngineManager();
    protected static final String PROPS_PATH = "/struts-scripting.properties";
    protected static final String ENGINE_BASE = "struts-scripting.engine.";
    protected static final String FILTERS_BASE = "struts-scripting.filters.";
    private static ScriptContextFilter[] filters = null;
    private ConcurrentHashMap<String, Script> scripts = new ConcurrentHashMap();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        String scriptName = this.parseScriptName(mapping.getParameter(), params);
        if (scriptName == null) {
            LOG.error("No script specified in the parameter attribute");
            throw new Exception("No script specified");
        }
        LOG.debug("Executing script: {}", (Object)scriptName);
        HttpSession session = request.getSession();
        ServletContext application = this.getServlet().getServletContext();
        Script script = this.loadScript(scriptName, application);
        Bindings bindings = script.getBindings();
        bindings.putAll((Map<? extends String, ? extends Object>)params);
        bindings.put("request", (Object)request);
        bindings.put("response", (Object)response);
        if (session == null) {
            LOG.debug("HTTP session is null");
        } else {
            bindings.put("session", (Object)session);
        }
        bindings.put("application", (Object)application);
        bindings.put("log", (Object)LOG);
        StrutsInfo struts = new StrutsInfo(this, mapping, form, this.getResources(request));
        bindings.put("struts", (Object)struts);
        ScriptContext scriptContext = script.scriptEngine.getContext();
        for (ScriptContextFilter filter : filters) {
            filter.apply(scriptContext);
        }
        script.eval();
        ActionForward af = struts.getForward();
        return af;
    }

    protected String parseScriptName(String url, Map<String, String> params) {
        String[] args;
        LOG.debug("Parsing {}", (Object)url);
        if (url == null) {
            return null;
        }
        String[] parsed = url.split("\\?", 2);
        if (parsed.length == 0) {
            return null;
        }
        if (parsed.length == 1) {
            LOG.debug("No query string: {}", (Object)parsed[0]);
            return parsed[0];
        }
        LOG.debug("Found a query string");
        for (String arg : args = parsed[1].split("&")) {
            int i = arg.indexOf(61);
            String key = this.urlDecode(i > 0 ? arg.substring(0, i) : arg);
            while (params.containsKey(key)) {
                LOG.warn("Script variable {} already exists", (Object)key);
                key = "_" + key;
            }
            String value = i > 0 && arg.length() > i + 1 ? this.urlDecode(arg.substring(i + 1)) : null;
            params.put(key, value);
            LOG.debug("Registering param {} with value {}", (Object)key, value);
        }
        return parsed[0];
    }

    private String urlDecode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("URL-Decode: ", (Throwable)e);
            return null;
        }
    }

    protected Script loadScript(String name, ServletContext context) throws IOException, ScriptException {
        Script script = this.scripts.compute(name, (key, oldValue) -> {
            if (oldValue == null) {
                return new Script(SCRIPT_ENGINE_MANAGER, context, (String)key);
            }
            oldValue.checkNewContent();
            return oldValue;
        });
        try {
            script.checkExceptions();
        }
        catch (IOException e) {
            LOG.error("Unable to load script: {}", (Object)script.name, (Object)e);
            throw e;
        }
        catch (ScriptException e) {
            LOG.error("Unable to compile script: {}", (Object)script.name, (Object)e);
            throw e;
        }
        return script;
    }

    protected static ScriptContextFilter[] loadFilters(Properties props) {
        ArrayList<ScriptContextFilter> list = new ArrayList<ScriptContextFilter>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = e.nextElement().toString().trim();
            if (!propName.startsWith(FILTERS_BASE) || !propName.endsWith("class")) continue;
            String name = propName.substring(FILTERS_BASE.length(), propName.indexOf(".", FILTERS_BASE.length()));
            String clazz = props.getProperty(propName).trim();
            try {
                Class<ScriptContextFilter> cls = Class.forName(clazz).asSubclass(ScriptContextFilter.class);
                ScriptContextFilter f = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                f.init(name, props);
                list.add(f);
                LOG.info("Loaded {} filter: {}", (Object)name, (Object)clazz);
            }
            catch (Exception ex) {
                LOG.error("Unable to load {} filter: {}", (Object)name, (Object)clazz);
            }
        }
        return list.toArray(new ScriptContextFilter[0]);
    }

    public void saveToken(HttpServletRequest req) {
        super.saveToken(req);
    }

    public boolean isCancelled(HttpServletRequest req) {
        return super.isCancelled(req);
    }

    public boolean isTokenValid(HttpServletRequest req) {
        return super.isTokenValid(req);
    }

    public void resetToken(HttpServletRequest req) {
        super.resetToken(req);
    }

    public Locale getLocale(HttpServletRequest req) {
        return super.getLocale(req);
    }

    public void saveMessages(HttpServletRequest req, ActionMessages mes) {
        super.saveMessages(req, mes);
    }

    @Deprecated
    public void saveErrors(HttpServletRequest req, ActionErrors errs) {
        super.saveErrors(req, (ActionMessages)errs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties props = new Properties();
        InputStream in = null;
        String propsPath = PROPS_PATH;
        try {
            in = ScriptAction.class.getClassLoader().getResourceAsStream(propsPath);
            if (in == null) {
                propsPath = "/struts-bsf.properties";
                in = ScriptAction.class.getClassLoader().getResourceAsStream(propsPath);
                if (in != null) {
                    LOG.warn("The struts-bsf.properties file has been deprecated.  Please use struts-scripting.properties instead.");
                } else {
                    LOG.warn("struts-scripting.properties not found, using default engine mappings.");
                }
            }
            if (in != null) {
                props.load(in);
            }
        }
        catch (Exception ex) {
            LOG.warn("Unable to load struts-scripting.properties, using  default engine mappings.");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    LOG.warn("Error closing '{}'", (Object)propsPath, (Object)ioe);
                }
            }
        }
        List<ScriptEngineFactory> allSefs = SCRIPT_ENGINE_MANAGER.getEngineFactories();
        int pos = ENGINE_BASE.length();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = e.nextElement().toString();
            if (!propName.startsWith(ENGINE_BASE) || !propName.endsWith(".extensions")) continue;
            String name = propName.substring(pos, propName.indexOf(46, pos));
            ScriptEngineFactory[] sefs = (ScriptEngineFactory[])allSefs.stream().filter(sef -> sef.getNames().contains(name)).toArray(ScriptEngineFactory[]::new);
            if (sefs.length == 0) {
                LOG.warn("No ScriptEngineFactory found - name: '{}'", (Object)name);
                continue;
            }
            if (sefs.length > 1) {
                LOG.warn("More than one ScriptEngineFactory found, taking the first one - name: '{}'", (Object)name);
            }
            ScriptEngineFactory sef2 = sefs[0];
            LOG.info("Found ScriptingEngineFactory - name: {} language: {} {}", new Object[]{name, sef2.getLanguageName(), sef2.getLanguageVersion()});
            String propValue = props.getProperty(propName).trim();
            String[] exts = propValue.split(",");
            if (exts.length == 0) continue;
            LOG.atInfo().log(() -> {
                StringBuilder sb = new StringBuilder();
                sb.append("Registering extension");
                if (exts.length > 1) {
                    sb.append('s');
                }
                sb.append(" to ScriptingEngineFactory - name: '").append(name).append("' ext");
                if (exts.length > 1) {
                    sb.append('s');
                }
                sb.append(": ");
                if (exts.length == 1) {
                    sb.append('\'').append(exts[0]).append('\'');
                } else {
                    sb.append(Arrays.toString(exts));
                }
                return sb.toString();
            });
            for (String ext : exts) {
                if ((ext = ext.trim()).isEmpty()) continue;
                SCRIPT_ENGINE_MANAGER.registerEngineExtension(ext, sef2);
            }
        }
        filters = ScriptAction.loadFilters(props);
    }
}

