/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

class IOUtils {
    private IOUtils() {
    }

    static FileTime getLastModifiedTime(Path path) throws IOException {
        if (path == null) {
            return null;
        }
        BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        return attr.lastModifiedTime();
    }

    static String getStringFromReader(Reader reader) throws IOException {
        try (BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            String lineSeparator = System.lineSeparator();
            StringBuilder sb = new StringBuilder(8192);
            while ((line = br.readLine()) != null) {
                sb.append(lineSeparator).append(line);
            }
            String string = sb.substring(sb.length() == 0 ? 0 : lineSeparator.length());
            return string;
        }
    }
}

