/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.cabParser.structure;

import dorkbox.cabParser.CabException;
import dorkbox.cabParser.CabStreamSaver;
import dorkbox.cabParser.CorruptCabException;
import dorkbox.cabParser.structure.CabConstants;
import dorkbox.util.bytes.LittleEndian;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class CabHeader
implements CabConstants {
    public long reserved1;
    public long cbCabinet;
    public long reserved2;
    public long coffFiles;
    public long reserved3;
    public int version;
    public int cFolders;
    public int cFiles;
    public int flags;
    public int setID;
    public int iCabinet;
    public int cbCFHeader = 0;
    public int cbCFFolder = 0;
    public int cbCFData = 0;
    private CabStreamSaver decoder;

    public CabHeader(CabStreamSaver paramCabDecoderInterface) {
        this.decoder = paramCabDecoderInterface;
    }

    public void read(InputStream input) throws IOException, CabException {
        int i = input.read();
        int j = input.read();
        int k = input.read();
        int m = input.read();
        if (i != 77 || j != 83 || k != 67 || m != 70) {
            throw new CorruptCabException("Missing header signature");
        }
        this.reserved1 = LittleEndian.UInt_.from((InputStream)input).longValue();
        this.cbCabinet = LittleEndian.UInt_.from((InputStream)input).longValue();
        this.reserved2 = LittleEndian.UInt_.from((InputStream)input).longValue();
        this.coffFiles = LittleEndian.UInt_.from((InputStream)input).longValue();
        this.reserved3 = LittleEndian.UInt_.from((InputStream)input).longValue();
        this.version = LittleEndian.UShort_.from((InputStream)input).intValue();
        this.cFolders = LittleEndian.UShort_.from((InputStream)input).intValue();
        this.cFiles = LittleEndian.UShort_.from((InputStream)input).intValue();
        this.flags = LittleEndian.UShort_.from((InputStream)input).intValue();
        this.setID = LittleEndian.UShort_.from((InputStream)input).intValue();
        this.iCabinet = LittleEndian.UShort_.from((InputStream)input).intValue();
        if ((this.flags & 4) == 4) {
            this.cbCFHeader = LittleEndian.UShort_.from((InputStream)input).intValue();
            this.cbCFFolder = input.read();
            this.cbCFData = input.read();
        }
        if ((this.flags & 1) == 1 || (this.flags & 2) == 2) {
            throw new CabException("Spanned cabinets not supported");
        }
        if (this.cbCFHeader != 0) {
            if (this.decoder.saveReservedAreaData(null, this.cbCFHeader)) {
                byte[] data = new byte[this.cbCFHeader];
                if (this.cbCFHeader != 0) {
                    int read;
                    for (int readTotal = 0; readTotal < this.cbCFHeader; readTotal += read) {
                        read = input.read(data, readTotal, this.cbCFHeader - readTotal);
                        if (read >= 0) continue;
                        throw new EOFException();
                    }
                }
                this.decoder.saveReservedAreaData(data, this.cbCFHeader);
                return;
            }
            input.skip(this.cbCFHeader);
        }
    }
}

