/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.cabParser.structure;

import dorkbox.cabParser.structure.CabConstants;
import dorkbox.util.bytes.LittleEndian;
import java.io.IOException;
import java.io.InputStream;

public final class CabFolderEntry
implements CabConstants {
    public long coffCabStart;
    public int cCFData;
    public int compressionMethod = 0;

    public int getCompressionMethod() {
        return this.compressionMethod & 0xF;
    }

    public void read(InputStream input) throws IOException {
        this.coffCabStart = LittleEndian.UInt_.from((InputStream)input).longValue();
        this.cCFData = LittleEndian.UShort_.from((InputStream)input).intValue();
        this.compressionMethod = LittleEndian.UShort_.from((InputStream)input).intValue();
    }

    public int getCompressionWindowSize() {
        if (this.compressionMethod == 0) {
            return 0;
        }
        if (this.compressionMethod == 1) {
            return 16;
        }
        return (this.compressionMethod & 0x1F00) >>> 8;
    }

    public String compressionToString() {
        switch (this.getCompressionMethod()) {
            default: {
                return "UNKNOWN";
            }
            case 0: {
                return "NONE";
            }
            case 1: {
                return "MSZIP";
            }
            case 2: {
                return "QUANTUM:" + Integer.toString(this.getCompressionWindowSize());
            }
            case 3: 
        }
        return "LZX:" + Integer.toString(this.getCompressionWindowSize());
    }

    public void setCompression(int a, int b) {
        this.compressionMethod = b << 8 | a;
    }
}

