/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.cabParser.decompress.lzx;

import dorkbox.cabParser.CabException;
import dorkbox.cabParser.CorruptCabException;
import dorkbox.cabParser.decompress.Decompressor;
import dorkbox.cabParser.decompress.lzx.DecompressLzxTree;
import dorkbox.cabParser.decompress.lzx.LZXConstants;

public final class DecompressLzx
implements Decompressor,
LZXConstants {
    private int[] extraBits = new int[51];
    private int[] positionBase = new int[51];
    private DecompressLzxTree mainTree;
    private DecompressLzxTree lengthTree;
    private DecompressLzxTree alignedTree;
    private DecompressLzxTree preTree;
    private int wndSize;
    private int windowMask;
    private int mainElements;
    private int blocksRemaining;
    private int blockType;
    private int blockRemaining;
    private int blockLength;
    private int windowPosition;
    private int R0;
    private int R1;
    private int R2;
    private byte[] localWindow;
    private int windowSize;
    private boolean readHeader;
    private int outputPosition;
    private int index;
    private int length;
    private byte[] inputBytes;
    private boolean abort;
    int bitsLeft;
    private int blockAlignOffset;
    private int intelFileSize;
    private int intelCursorPos;
    private byte[] savedBytes = new byte[6];
    private boolean intelStarted;
    private int framesRead;

    public DecompressLzx() {
        int i = 4;
        int j = 1;
        do {
            this.extraBits[i] = j;
            this.extraBits[i + 1] = j++;
            i += 2;
        } while (j <= 16);
        do {
            this.extraBits[i++] = 17;
        } while (i < 51);
        i = -2;
        for (j = 0; j < this.extraBits.length; ++j) {
            this.positionBase[j] = i;
            i += 1 << this.extraBits[j];
        }
        this.windowSize = -1;
    }

    @Override
    public void init(int windowBits) throws CabException {
        this.wndSize = 1 << windowBits;
        this.windowMask = this.wndSize - 1;
        this.reset(windowBits);
    }

    @Override
    public void decompress(byte[] inputBytes, byte[] outputBytes, int inputLength, int outputLength) throws CabException {
        this.abort = false;
        this.index = 0;
        this.inputBytes = inputBytes;
        this.length = inputBytes.length;
        this.initBitStream();
        int decompressedOutputLength = this.decompressLoop(outputLength);
        System.arraycopy(this.localWindow, this.outputPosition, outputBytes, 0, decompressedOutputLength);
        if (this.framesRead++ < 32768 && this.intelFileSize != 0) {
            this.decodeIntelBlock(outputBytes, decompressedOutputLength);
        }
    }

    @Override
    public int getMaxGrowth() {
        return 6144;
    }

    @Override
    public void reset(int windowBits) throws CabException {
        if (this.windowSize == windowBits) {
            this.mainTree.reset();
            this.lengthTree.reset();
            this.alignedTree.reset();
        } else {
            this.maybeReset();
            int i = 256 + this.mainElements * 8;
            this.localWindow = new byte[this.wndSize + 261];
            this.preTree = new DecompressLzxTree(20, 8, this, null);
            this.mainTree = new DecompressLzxTree(i, 9, this, this.preTree);
            this.lengthTree = new DecompressLzxTree(249, 6, this, this.preTree);
            this.alignedTree = new DecompressLzxTree(8, 7, this, this.preTree);
        }
        this.windowSize = windowBits;
        this.R2 = 1;
        this.R1 = 1;
        this.R0 = 1;
        this.blocksRemaining = 0;
        this.windowPosition = 0;
        this.intelCursorPos = 0;
        this.readHeader = true;
        this.intelStarted = false;
        this.framesRead = 0;
        this.blockType = 4;
    }

    private int decompressLoop(int bytesToRead) throws CabException {
        int m;
        int k;
        int i = bytesToRead;
        if (this.readHeader) {
            if (this.readBits(1) == 1) {
                k = this.readBits(16);
                m = this.readBits(16);
                this.intelFileSize = k << 16 | m;
            } else {
                this.intelFileSize = 0;
            }
            this.readHeader = false;
        }
        int lastWindowPosition = 0;
        while (bytesToRead > 0) {
            if (this.blocksRemaining == 0) {
                if (this.blockType == 3) {
                    if ((this.blockLength & 1) != 0 && this.index < this.length) {
                        ++this.index;
                    }
                    this.blockType = 4;
                    this.initBitStream();
                }
                this.blockType = this.readBits(3);
                k = this.readBits(8);
                m = this.readBits(8);
                int n = this.readBits(8);
                if (this.abort) break;
                this.blockRemaining = this.blockLength = (k << 16) + (m << 8) + n;
                if (this.blockType == 2) {
                    this.alignedTree.readLengths();
                    this.alignedTree.buildTable();
                }
                if (this.blockType == 2 || this.blockType == 1) {
                    this.mainTree.read();
                    this.lengthTree.read();
                    this.mainTree.readLengths(0, 256);
                    this.mainTree.readLengths(256, 256 + this.mainElements * 8);
                    this.mainTree.buildTable();
                    if (this.mainTree.LENS[232] != 0) {
                        this.intelStarted = true;
                    }
                    this.lengthTree.readLengths(0, 249);
                    this.lengthTree.buildTable();
                } else if (this.blockType == 3) {
                    this.intelStarted = true;
                    this.index -= 2;
                    if (this.index < 0 || this.index + 12 >= this.length) {
                        throw new CorruptCabException();
                    }
                    this.R0 = this.readInt();
                    this.R1 = this.readInt();
                    this.R2 = this.readInt();
                } else {
                    throw new CorruptCabException();
                }
            }
            this.blocksRemaining = 1;
            while (this.blockRemaining > 0 && bytesToRead > 0) {
                k = this.blockRemaining < bytesToRead ? this.blockRemaining : bytesToRead;
                this.decompressBlockActions(k);
                this.blockRemaining -= k;
                bytesToRead -= k;
                lastWindowPosition += k;
            }
            if (this.blockRemaining == 0) {
                this.blocksRemaining = 0;
            }
            if (bytesToRead != 0 || this.blockAlignOffset == 16) continue;
            this.readNumberBits(this.blockAlignOffset);
        }
        if (lastWindowPosition != i) {
            throw new CorruptCabException();
        }
        this.outputPosition = this.windowPosition == 0 ? this.wndSize - lastWindowPosition : this.windowPosition - lastWindowPosition;
        return lastWindowPosition;
    }

    private void decodeIntelBlock(byte[] bytes, int outLength) {
        int abs_off;
        if (outLength <= 6 || !this.intelStarted) {
            this.intelCursorPos += outLength;
            return;
        }
        int cursorPos = this.intelCursorPos;
        int fileSize = this.intelFileSize;
        int adjustedOutLength = outLength - 6;
        for (abs_off = 0; abs_off < 6; ++abs_off) {
            this.savedBytes[abs_off] = bytes[adjustedOutLength + abs_off];
            bytes[adjustedOutLength + abs_off] = -24;
        }
        int dataIndex = 0;
        int cursor_pos = cursorPos + adjustedOutLength;
        while (cursorPos < cursor_pos) {
            while (bytes[dataIndex++] == -24 && cursorPos < cursor_pos) {
                int rel_off;
                abs_off = bytes[dataIndex] & 0xFF | (bytes[dataIndex + 1] & 0xFF) << 8 | (bytes[dataIndex + 2] & 0xFF) << 16 | (bytes[dataIndex + 3] & 0xFF) << 24;
                if (abs_off >= 0) {
                    if (abs_off < fileSize) {
                        rel_off = abs_off - cursorPos;
                        bytes[dataIndex] = (byte)(rel_off & 0xFF);
                        bytes[dataIndex + 1] = (byte)(rel_off >>> 8 & 0xFF);
                        bytes[dataIndex + 2] = (byte)(rel_off >>> 16 & 0xFF);
                        bytes[dataIndex + 3] = (byte)(rel_off >>> 24);
                    }
                } else if (abs_off >= -cursorPos) {
                    rel_off = abs_off + this.intelFileSize;
                    bytes[dataIndex] = (byte)(rel_off & 0xFF);
                    bytes[dataIndex + 1] = (byte)(rel_off >>> 8 & 0xFF);
                    bytes[dataIndex + 2] = (byte)(rel_off >>> 16 & 0xFF);
                    bytes[dataIndex + 3] = (byte)(rel_off >>> 24);
                }
                dataIndex += 4;
                cursorPos += 5;
            }
            ++cursorPos;
        }
        this.intelCursorPos = cursor_pos + 6;
        for (abs_off = 0; abs_off < 6; ++abs_off) {
            bytes[adjustedOutLength + abs_off] = this.savedBytes[abs_off];
        }
    }

    private void decompressBlockActions(int bytesToRead) throws CabException {
        this.windowPosition &= this.windowMask;
        if (this.windowPosition + bytesToRead > this.wndSize) {
            throw new CabException();
        }
        switch (this.blockType) {
            case 3: {
                this.uncompressedAlgo(bytesToRead);
                return;
            }
            case 2: {
                this.alignedAlgo(bytesToRead);
                return;
            }
            case 1: {
                this.verbatimAlgo(bytesToRead);
                return;
            }
        }
        throw new CorruptCabException();
    }

    void readNumberBits(int numBits) {
        this.bitsLeft <<= numBits;
        this.blockAlignOffset -= numBits;
        if (this.blockAlignOffset <= 0) {
            this.bitsLeft |= this.readShort() << -this.blockAlignOffset;
            this.blockAlignOffset += 16;
        }
    }

    private void initBitStream() {
        if (this.blockType != 3) {
            this.bitsLeft = this.readShort() << 16 | this.readShort();
            this.blockAlignOffset = 16;
        }
    }

    private void maybeReset() {
        this.mainElements = 4;
        int i = 4;
        do {
            ++this.mainElements;
        } while ((i += 1 << this.extraBits[this.mainElements]) < this.wndSize);
    }

    private void verbatimAlgo(int this_run) throws CorruptCabException {
        int i = this.windowPosition;
        int mask = this.windowMask;
        byte[] windowPosition = this.localWindow;
        int r0 = this.R0;
        int r1 = this.R1;
        int r2 = this.R2;
        int[] arrayOfInt1 = this.extraBits;
        int[] arrayOfInt2 = this.positionBase;
        DecompressLzxTree mainTree = this.mainTree;
        DecompressLzxTree lengthTree = this.lengthTree;
        while (this_run > 0) {
            int matchOffset;
            int main_element = mainTree.decodeElement();
            if (main_element < 256) {
                windowPosition[i++] = (byte)main_element;
                --this_run;
                continue;
            }
            int match_length = (main_element -= 256) & 7;
            if (match_length == 7) {
                match_length += lengthTree.decodeElement();
            }
            if ((matchOffset = main_element >>> 3) == 0) {
                matchOffset = r0;
            } else if (matchOffset == 1) {
                matchOffset = r1;
                r1 = r0;
                r0 = matchOffset;
            } else if (matchOffset > 2) {
                matchOffset = matchOffset > 3 ? this.verbatimAlgo2(arrayOfInt1[matchOffset]) + arrayOfInt2[matchOffset] : 1;
                r2 = r1;
                r1 = r0;
                r0 = matchOffset;
            } else {
                matchOffset = r2;
                r2 = r0;
                r0 = matchOffset;
            }
            this_run -= (match_length += 2);
            while (match_length > 0) {
                windowPosition[i] = windowPosition[i - matchOffset & mask];
                ++i;
                --match_length;
            }
        }
        if (this_run != 0) {
            throw new CorruptCabException();
        }
        this.R0 = r0;
        this.R1 = r1;
        this.R2 = r2;
        this.windowPosition = i;
    }

    private int verbatimAlgo2(int position) {
        int i = this.bitsLeft >>> 32 - position;
        this.bitsLeft <<= position;
        this.blockAlignOffset -= position;
        if (this.blockAlignOffset <= 0) {
            this.bitsLeft |= this.readShort() << -this.blockAlignOffset;
            this.blockAlignOffset += 16;
            if (this.blockAlignOffset <= 0) {
                this.bitsLeft |= this.readShort() << -this.blockAlignOffset;
                this.blockAlignOffset += 16;
            }
        }
        return i;
    }

    private void alignedAlgo(int this_run) throws CorruptCabException {
        int windowPos = this.windowPosition;
        int mask = this.windowMask;
        byte[] window = this.localWindow;
        int r0 = this.R0;
        int r1 = this.R1;
        int r2 = this.R2;
        while (this_run > 0) {
            int match_offset;
            int mainElement = this.mainTree.decodeElement();
            if (mainElement < 256) {
                window[windowPos] = (byte)mainElement;
                windowPos = windowPos + 1 & mask;
                --this_run;
                continue;
            }
            int matchLength = (mainElement -= 256) & 7;
            if (matchLength == 7) {
                matchLength += this.lengthTree.decodeElement();
            }
            if ((match_offset = mainElement >>> 3) > 2) {
                int extra = this.extraBits[match_offset];
                match_offset = this.positionBase[match_offset];
                match_offset = extra > 3 ? (match_offset += (this.readBits(extra - 3) << 3) + this.alignedTree.decodeElement()) : (extra == 3 ? (match_offset += this.alignedTree.decodeElement()) : (extra > 0 ? (match_offset += this.readBits(extra)) : 1));
                r2 = r1;
                r1 = r0;
                r0 = match_offset;
            } else if (match_offset == 0) {
                match_offset = r0;
            } else if (match_offset == 1) {
                match_offset = r1;
                r1 = r0;
                r0 = match_offset;
            } else {
                match_offset = r2;
                r2 = r0;
                r0 = match_offset;
            }
            this_run -= (matchLength += 2);
            while (matchLength > 0) {
                window[windowPos] = window[windowPos - match_offset & mask];
                windowPos = windowPos + 1 & mask;
                --matchLength;
            }
        }
        if (this_run != 0) {
            throw new CorruptCabException();
        }
        this.R0 = r0;
        this.R1 = r1;
        this.R2 = r2;
        this.windowPosition = windowPos;
    }

    private int readShort() {
        if (this.index < this.length) {
            int i = this.inputBytes[this.index] & 0xFF | (this.inputBytes[this.index + 1] & 0xFF) << 8;
            this.index += 2;
            return i;
        }
        this.abort = true;
        this.index = 0;
        return 0;
    }

    int readBits(int numBitsToRead) {
        int i = this.bitsLeft >>> 32 - numBitsToRead;
        this.readNumberBits(numBitsToRead);
        return i;
    }

    private void uncompressedAlgo(int length) throws CorruptCabException {
        if (this.index + length > this.length || this.windowPosition + length > this.wndSize) {
            throw new CorruptCabException();
        }
        this.intelStarted = true;
        System.arraycopy(this.inputBytes, this.index, this.localWindow, this.windowPosition, length);
        this.index += length;
        this.windowPosition += length;
    }

    private int readInt() {
        int i = this.inputBytes[this.index] & 0xFF | (this.inputBytes[this.index + 1] & 0xFF) << 8 | (this.inputBytes[this.index + 2] & 0xFF) << 16 | (this.inputBytes[this.index + 3] & 0xFF) << 24;
        this.index += 4;
        return i;
    }
}

