/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.cabParser.decompress;

import dorkbox.cabParser.CabException;
import dorkbox.cabParser.CorruptCabException;
import dorkbox.cabParser.decompress.Decompressor;
import dorkbox.cabParser.decompress.lzx.DecompressLzx;
import dorkbox.cabParser.decompress.none.DecompressNone;
import dorkbox.cabParser.decompress.zip.DecompressZip;
import dorkbox.cabParser.structure.CabConstants;
import dorkbox.cabParser.structure.CfDataRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class CabDecompressor
implements CabConstants {
    private byte[] readBuffer;
    private byte[] bytes;
    private long uncompressedDataSize;
    private int outputOffset;
    private int compressionMethod;
    private InputStream inputStream;
    private Decompressor decompressor;
    private CfDataRecord cfDataRecord;

    public CabDecompressor(InputStream paramInputStream, int sizeOfBlockData) {
        this.inputStream = paramInputStream;
        this.uncompressedDataSize = 0L;
        this.outputOffset = 0;
        this.compressionMethod = -1;
        this.bytes = new byte[33028];
        this.cfDataRecord = new CfDataRecord(sizeOfBlockData);
    }

    public void read(long size, OutputStream outputStream) throws IOException, CabException {
        if (this.uncompressedDataSize >= size) {
            outputStream.write(this.bytes, this.outputOffset, (int)size);
            this.uncompressedDataSize -= size;
            this.outputOffset = (int)((long)this.outputOffset + size);
            return;
        }
        if (this.uncompressedDataSize > 0L) {
            outputStream.write(this.bytes, this.outputOffset, (int)this.uncompressedDataSize);
        }
        size -= this.uncompressedDataSize;
        this.outputOffset = 0;
        this.uncompressedDataSize = 0L;
        while (size > 0L) {
            this.cfDataRecord.read(this.inputStream, this.readBuffer);
            if (!this.cfDataRecord.validateCheckSum(this.readBuffer)) {
                throw new CorruptCabException("Invalid CFDATA checksum");
            }
            this.decompressor.decompress(this.readBuffer, this.bytes, this.cfDataRecord.cbData, this.cfDataRecord.cbUncomp);
            this.uncompressedDataSize = this.cfDataRecord.cbUncomp;
            this.outputOffset = 0;
            if (this.uncompressedDataSize >= size) {
                outputStream.write(this.bytes, this.outputOffset, (int)size);
                this.outputOffset = (int)((long)this.outputOffset + size);
                this.uncompressedDataSize -= size;
                size = 0L;
                continue;
            }
            outputStream.write(this.bytes, this.outputOffset, (int)this.uncompressedDataSize);
            size -= this.uncompressedDataSize;
            this.outputOffset = 0;
            this.uncompressedDataSize = 0L;
        }
    }

    public void initialize(int compressionMethod) throws CabException {
        int type = compressionMethod & 0xF;
        int windowBits = (compressionMethod & 0x1F00) >>> 8;
        if (compressionMethod == this.compressionMethod) {
            this.decompressor.reset(windowBits);
            return;
        }
        switch (type) {
            case 0: {
                this.decompressor = new DecompressNone();
                break;
            }
            case 1: {
                this.decompressor = new DecompressZip();
                break;
            }
            case 3: {
                this.decompressor = new DecompressLzx();
                break;
            }
            default: {
                throw new CabException("Unknown compression type " + type);
            }
        }
        this.readBuffer = new byte[32768 + this.decompressor.getMaxGrowth()];
        this.decompressor.init(windowBits);
        this.compressionMethod = compressionMethod;
    }
}

