/*
 * Decompiled with CFR 0.152.
 */
package com.dokandev.dokan.util;

import java.util.EnumSet;
import java.util.Set;

public enum ShareMode {
    FILE_SHARE_READ(1),
    FILE_SHARE_WRITE(2),
    FILE_SHARE_DELETE(4);

    private final int mask;

    private ShareMode(int mask) {
        this.mask = mask;
    }

    public int mask() {
        return this.mask;
    }

    public static Set<ShareMode> fromInt(int shareMode) {
        EnumSet<ShareMode> set = EnumSet.noneOf(ShareMode.class);
        for (ShareMode e : (ShareMode[])ShareMode.class.getEnumConstants()) {
            if ((e.mask() & shareMode) != e.mask()) continue;
            set.add(e);
        }
        return set;
    }

    public static int toInt(ShareMode ... modes) {
        int mask = 0;
        for (ShareMode e : modes) {
            mask |= e.mask();
        }
        return mask;
    }

    public static String toString(int shareMode) {
        String sRtn = "";
        for (ShareMode mask : ShareMode.fromInt(shareMode)) {
            if (!"".equals(sRtn)) {
                sRtn = sRtn + " | ";
            }
            sRtn = sRtn + mask.name();
        }
        return "(" + String.valueOf(shareMode) + ") " + sRtn;
    }
}

