/*
 * Decompiled with CFR 0.152.
 */
package com.dokandev.dokan.util;

import java.util.EnumSet;
import java.util.Set;

public enum AccessMask {
    FILE_READ_DATA(1),
    FILE_WRITE_DATA(2),
    FILE_APPEND_DATA(4),
    FILE_READ_EA(8),
    FILE_WRITE_EA(16),
    FILE_EXECUTE(32),
    FILE_TRAVERSE(32),
    FILE_DELETE_CHILD(64),
    FILE_READ_ATTRIBUTES(128),
    FILE_WRITE_ATTRIBUTES(256),
    DELETE(65536),
    READ_CONTROL(131072),
    WRITE_DAC(262144),
    WRITE_OWNER(524288),
    SYNCHRONIZE(0x100000),
    ACCESS_SYSTEM_SECURITY(0x1000000),
    MAXIMUM_ALLOWED(0x2000000),
    GENERIC_ALL(0x10000000),
    GENERIC_EXECUTE(0x20000000),
    GENERIC_WRITE(0x40000000),
    GENERIC_READ(Integer.MIN_VALUE);

    private final int mask;

    private AccessMask(int value) {
        this.mask = value;
    }

    public int mask() {
        return this.mask;
    }

    public static Set<AccessMask> fromInt(int accessMask) {
        EnumSet<AccessMask> set = EnumSet.noneOf(AccessMask.class);
        for (AccessMask e : (AccessMask[])AccessMask.class.getEnumConstants()) {
            if ((e.mask() & accessMask) != e.mask()) continue;
            set.add(e);
        }
        return set;
    }

    public static int toInt(AccessMask ... masks) {
        int mask = 0;
        for (AccessMask e : masks) {
            mask |= e.mask();
        }
        return mask;
    }

    public static String toString(int accessMask) {
        String sRtn = "";
        for (AccessMask mask : AccessMask.fromInt(accessMask)) {
            if (!"".equals(sRtn)) {
                sRtn = sRtn + " | ";
            }
            sRtn = sRtn + mask.name();
        }
        return "(" + String.valueOf(accessMask) + ") " + sRtn;
    }
}

