/*
 * Decompiled with CFR 0.152.
 */
package com.dokandev.dokan;

import java.util.EnumSet;
import java.util.Set;

public class FileSecurity {
    public static EnumSet<FileSecurityFlags> getFlags(int value) {
        EnumSet<FileSecurityFlags> flags = EnumSet.noneOf(FileSecurityFlags.class);
        for (FileSecurityFlags flag : FileSecurityFlags.values()) {
            long flagValue = flag.getValue();
            if ((flagValue & (long)value) != flagValue) continue;
            flags.add(flag);
        }
        return flags;
    }

    public static long getStatusValue(Set<FileSecurityFlags> flags) {
        long value = 0L;
        for (FileSecurityFlags flag : flags) {
            value |= (long)flag.getValue();
        }
        return value;
    }

    public static String toString(int value) {
        String result = "";
        EnumSet<FileSecurityFlags> flags = FileSecurity.getFlags(value);
        for (FileSecurityFlags flag : flags) {
            result = result + flag.toString() + " | ";
        }
        return result;
    }

    public static enum FileSecurityFlags {
        SECURITY_ANONYMOUS(0),
        SECURITY_CONTEXT_TRACKING(262144),
        SECURITY_DELEGATION(196608),
        SECURITY_EFFECTIVE_ONLY(524288),
        SECURITY_IDENTIFICATION(65536),
        SECURITY_IMPERSONATION(131072);

        private int value;

        private FileSecurityFlags(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

