/*
 * Decompiled with CFR 0.152.
 */
package com.dokandev.dokan;

public final class DokanOptions {
    private final int version;
    private final int threadCount;
    private final long optionsMode;
    private final long globalContext;
    private final String mountPoint;
    public String metaFilePath = null;

    public DokanOptions(int version, int threadCount, long optionsMode, long globalContext, String mountPoint) {
        this.version = version;
        this.threadCount = threadCount;
        this.optionsMode = optionsMode;
        this.globalContext = globalContext;
        this.mountPoint = DokanOptions.checkMountPoint(mountPoint);
    }

    public static String checkMountPoint(String mountPoint) {
        if (mountPoint == null) {
            throw new NullPointerException();
        }
        return mountPoint;
    }

    public static Builder builder(String mountPoint) {
        return new Builder(mountPoint);
    }

    public int getVersion() {
        return this.version;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public long getOptionsMode() {
        return this.optionsMode;
    }

    public long getGlobalContext() {
        return this.globalContext;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public String toString() {
        return String.format(this.getClass() + " - " + ", version=" + this.version + ", threadCount=" + this.threadCount + ", optionsMode=" + this.optionsMode + ", globalContext=" + this.globalContext + ", mountPoint=" + this.mountPoint, new Object[0]);
    }

    public static class Builder {
        private int version = 0;
        private int threadCount = 0;
        private long optionsMode = 0L;
        private long globalContext = 0L;
        private final String mountPoint;

        Builder(String mountPoint) {
            this.mountPoint = DokanOptions.checkMountPoint(mountPoint);
        }

        Builder(DokanOptions source) {
            this.version = source.version;
            this.threadCount = source.threadCount;
            this.optionsMode = source.optionsMode;
            this.globalContext = source.globalContext;
            this.mountPoint = source.mountPoint;
        }

        public Builder version(int version) {
            if (version < 0 || version > 65535) {
                throw new IllegalArgumentException(version + " is not in range [0, 65535]");
            }
            this.version = version;
            return this;
        }

        public Builder threadCount(int threadCount) {
            if (this.version < 0 || this.version > 65535) {
                throw new IllegalArgumentException(this.version + " is not in range [0, 65535]");
            }
            this.threadCount = threadCount;
            return this;
        }

        public Builder globalContext(long globalContext) {
            this.globalContext = globalContext;
            return this;
        }

        public DokanOptions build() {
            return new DokanOptions((short)this.version, (short)this.threadCount, this.optionsMode, this.globalContext, this.mountPoint);
        }
    }
}

