/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.AzureFileVolume;
import com.azure.resourcemanager.containerinstance.models.GitRepoVolume;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class Volume {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Volume.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="azureFile")
    private AzureFileVolume azureFile;
    @JsonProperty(value="emptyDir")
    private Object emptyDir;
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> secret;
    @JsonProperty(value="gitRepo")
    private GitRepoVolume gitRepo;

    public String name() {
        return this.name;
    }

    public Volume withName(String name) {
        this.name = name;
        return this;
    }

    public AzureFileVolume azureFile() {
        return this.azureFile;
    }

    public Volume withAzureFile(AzureFileVolume azureFile) {
        this.azureFile = azureFile;
        return this;
    }

    public Object emptyDir() {
        return this.emptyDir;
    }

    public Volume withEmptyDir(Object emptyDir) {
        this.emptyDir = emptyDir;
        return this;
    }

    public Map<String, String> secret() {
        return this.secret;
    }

    public Volume withSecret(Map<String, String> secret) {
        this.secret = secret;
        return this;
    }

    public GitRepoVolume gitRepo() {
        return this.gitRepo;
    }

    public Volume withGitRepo(GitRepoVolume gitRepo) {
        this.gitRepo = gitRepo;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Volume"));
        }
        if (this.azureFile() != null) {
            this.azureFile().validate();
        }
        if (this.gitRepo() != null) {
            this.gitRepo().validate();
        }
    }
}

