/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.containerinstance.fluent.ContainerInstanceManagementClient;
import com.azure.resourcemanager.containerinstance.implementation.ContainerGroupsImpl;
import com.azure.resourcemanager.containerinstance.implementation.ContainerInstanceManagementClientBuilder;
import com.azure.resourcemanager.containerinstance.models.ContainerGroups;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.azure.resourcemanager.storage.StorageManager;

public final class ContainerInstanceManager
extends Manager<ContainerInstanceManagementClient> {
    private ContainerGroupsImpl containerGroups;
    private final StorageManager storageManager;
    private final AuthorizationManager authorizationManager;
    private final NetworkManager networkManager;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ContainerInstanceManager authenticate(TokenCredential credential, AzureProfile profile) {
        return ContainerInstanceManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static ContainerInstanceManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new ContainerInstanceManager(httpPipeline, profile);
    }

    private ContainerInstanceManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new ContainerInstanceManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.storageManager = ((StorageManager.Configurable)AzureConfigurableImpl.configureHttpPipeline((HttpPipeline)httpPipeline, (AzureConfigurable)StorageManager.configure())).authenticate(null, profile);
        this.authorizationManager = ((AuthorizationManager.Configurable)AzureConfigurableImpl.configureHttpPipeline((HttpPipeline)httpPipeline, (AzureConfigurable)AuthorizationManager.configure())).authenticate(null, profile);
        this.networkManager = ((NetworkManager.Configurable)AzureConfigurableImpl.configureHttpPipeline((HttpPipeline)httpPipeline, (AzureConfigurable)NetworkManager.configure())).authenticate(null, profile);
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public AuthorizationManager authorizationManager() {
        return this.authorizationManager;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public ContainerGroups containerGroups() {
        if (this.containerGroups == null) {
            this.containerGroups = new ContainerGroupsImpl(this);
        }
        return this.containerGroups;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ContainerInstanceManager authenticate(TokenCredential credential, AzureProfile profile) {
            return ContainerInstanceManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ContainerInstanceManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

