/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator.validwhen;

import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.validator.validwhen.ValidWhenBaseVisitor;
import org.apache.struts.validator.validwhen.ValidWhenComparison;
import org.apache.struts.validator.validwhen.ValidWhenParser;
import org.apache.struts.validator.validwhen.ValidWhenResult;
import org.apache.struts.validator.validwhen.ValidWhenResultBigDecimal;
import org.apache.struts.validator.validwhen.ValidWhenResultBoolean;
import org.apache.struts.validator.validwhen.ValidWhenResultInteger;
import org.apache.struts.validator.validwhen.ValidWhenResultString;

public class ValidWhenEvaluator
extends ValidWhenBaseVisitor<ValidWhenResult<?>> {
    private final Object form;
    private final String value;
    private final int index;

    public ValidWhenEvaluator(Object form, String value, int index) {
        this.form = form;
        this.value = value;
        this.index = index;
    }

    @Override
    public ValidWhenResult<?> visitDecimal(ValidWhenParser.DecimalContext ctx) {
        String s = ctx.getText();
        return new ValidWhenResultBigDecimal(s);
    }

    @Override
    public ValidWhenResult<?> visitInteger(ValidWhenParser.IntegerContext ctx) {
        String s = ctx.getText();
        return new ValidWhenResultInteger(s);
    }

    @Override
    public ValidWhenResult<?> visitString(ValidWhenParser.StringContext ctx) {
        String s = ctx.getText();
        return new ValidWhenResultString(s.substring(1, s.length() - 1));
    }

    @Override
    public ValidWhenResult<?> visitField1(ValidWhenParser.Field1Context ctx) {
        return this.visitField(ctx.id1.getText() + "[" + this.index + "]" + ctx.id2.getText());
    }

    @Override
    public ValidWhenResult<?> visitField2(ValidWhenParser.Field2Context ctx) {
        return this.visitField(ctx.id1.getText() + "[" + ctx.idx.getText() + "]" + ctx.id2.getText());
    }

    @Override
    public ValidWhenResult<?> visitField3(ValidWhenParser.Field3Context ctx) {
        return this.visitField(ctx.id1.getText() + "[" + ctx.idx.getText() + "]");
    }

    @Override
    public ValidWhenResult<?> visitField4(ValidWhenParser.Field4Context ctx) {
        return this.visitField(ctx.id1.getText() + "[" + this.index + "]");
    }

    @Override
    public ValidWhenResult<?> visitField5(ValidWhenParser.Field5Context ctx) {
        return this.visitField(ctx.id1.getText());
    }

    private ValidWhenResult<?> visitField(String property) {
        return new ValidWhenResultString(ValidatorUtils.getValueAsString((Object)this.form, (String)property));
    }

    @Override
    public ValidWhenResult<?> visitLiteralNull(ValidWhenParser.LiteralNullContext ctx) {
        super.visitLiteralNull(ctx);
        return new ValidWhenResultString(null);
    }

    @Override
    public ValidWhenResult<?> visitLiteralThis(ValidWhenParser.LiteralThisContext ctx) {
        super.visitLiteralThis(ctx);
        return new ValidWhenResultString(this.value);
    }

    @Override
    public ValidWhenResult<?> visitJoinedExpression(ValidWhenParser.JoinedExpressionContext ctx) {
        boolean b1 = this.extracted((RuleContext)ctx.e1);
        boolean b2 = this.extracted((RuleContext)ctx.e2);
        boolean ret = false;
        switch (ctx.j.getType()) {
            case 7: {
                ret = b1 && b2;
                break;
            }
            case 8: {
                ret = b1 || b2;
            }
        }
        return new ValidWhenResultBoolean(ret);
    }

    private boolean extracted(RuleContext ctx) {
        ValidWhenResult result = (ValidWhenResult)ctx.accept((ParseTreeVisitor)this);
        return result == null ? false : result.toBoolean();
    }

    @Override
    public ValidWhenResult<?> visitComparisonExpression(ValidWhenParser.ComparisonExpressionContext ctx) {
        ValidWhenResult v1 = (ValidWhenResult)ctx.v1.accept(this);
        ValidWhenResult v2 = (ValidWhenResult)ctx.v2.accept(this);
        ValidWhenComparison comp = ValidWhenComparison.getComp(ctx.c.start.getType());
        return new ValidWhenResultBoolean(comp == null ? false : comp.compare(v1, v2));
    }

    @Override
    public ValidWhenResult<?> visitExprComp(ValidWhenParser.ExprCompContext ctx) {
        return (ValidWhenResult)ctx.comparisonExpression().accept(this);
    }

    @Override
    public ValidWhenResult<?> visitExprJoin(ValidWhenParser.ExprJoinContext ctx) {
        return (ValidWhenResult)ctx.joinedExpression().accept(this);
    }

    @Override
    public ValidWhenResult<?> visitExpression(ValidWhenParser.ExpressionContext ctx) {
        return (ValidWhenResult)ctx.expr().accept(this);
    }
}

