/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ValidatorPlugIn
implements PlugIn {
    private final Logger log = LoggerFactory.getLogger(ValidatorPlugIn.class);
    private static final String RESOURCE_DELIM = ",";
    public static final String VALIDATOR_KEY = "org.apache.commons.validator.VALIDATOR_RESOURCES";
    public static final String STOP_ON_ERROR_KEY = "org.apache.struts.validator.STOP_ON_ERROR";
    private ActionServlet servlet = null;
    protected ValidatorResources resources = null;
    private String pathnames = null;
    private boolean stopOnFirstError = true;

    public String getPathnames() {
        return this.pathnames;
    }

    public void setPathnames(String pathnames) {
        this.pathnames = pathnames;
    }

    public boolean isStopOnFirstError() {
        return this.stopOnFirstError;
    }

    public void setStopOnFirstError(boolean stopOnFirstError) {
        this.stopOnFirstError = stopOnFirstError;
    }

    @Override
    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        String validatorModuleKey = VALIDATOR_KEY + config.getPrefix();
        ServletContext servletContext = servlet.getServletContext();
        if (servletContext.getAttribute(validatorModuleKey) != null) {
            throw new UnavailableException("ValidatorPlugIn cannot be redefined for module '" + config.getPrefix() + "'");
        }
        try {
            this.initResources();
            servletContext.setAttribute(validatorModuleKey, (Object)this.resources);
            servletContext.setAttribute("org.apache.struts.validator.STOP_ON_ERROR." + config.getPrefix(), (Object)(this.stopOnFirstError ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnavailableException("Cannot load a validator resource from '" + this.pathnames + "'");
        }
    }

    @Override
    public void destroy() {
        this.log.debug("Destroying ValidatorPlugin");
        this.servlet = null;
        this.destroyResources();
    }

    protected void initResources() throws IOException, ServletException {
        if (this.pathnames == null || this.pathnames.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.pathnames, RESOURCE_DELIM);
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            while (st.hasMoreTokens()) {
                String validatorRules = st.nextToken().trim();
                this.log.info("Loading validation rules file from '{}'", (Object)validatorRules);
                URL input = this.servlet.getServletContext().getResource(validatorRules);
                if (input == null) {
                    input = this.getClass().getResource(validatorRules);
                }
                if (input != null) {
                    urlList.add(input);
                    continue;
                }
                throw new ServletException("Skipping validation rules file from '" + validatorRules + "'.  No url could be located.");
            }
            URL[] urlArray = urlList.toArray(new URL[0]);
            this.resources = new ValidatorResources(urlArray);
        }
        catch (SAXException sex) {
            this.log.error("Skipping all validation", (Throwable)sex);
            throw new ServletException((Throwable)sex);
        }
    }

    protected void destroyResources() {
        this.resources = null;
    }
}

