/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import jakarta.servlet.ServletContext;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ServletContextWriter
extends PrintWriter {
    protected StringBuffer buffer = new StringBuffer();
    protected ServletContext context = null;
    protected boolean error = false;

    public ServletContextWriter(ServletContext context) {
        super(new StringWriter());
        this.context = context;
    }

    @Override
    public boolean checkError() {
        this.flush();
        return this.error;
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        if (this.buffer.length() > 0) {
            this.context.log(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }

    @Override
    public void print(boolean b) {
        this.write(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(char[] c) {
        for (int i = 0; i < c.length; ++i) {
            this.write(c[i]);
        }
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(Object o) {
        this.write(o.toString());
    }

    @Override
    public void print(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void println() {
        this.flush();
    }

    @Override
    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    @Override
    public void println(char c) {
        this.write(c);
        this.println();
    }

    @Override
    public void println(char[] c) {
        for (int i = 0; i < c.length; ++i) {
            this.print(c[i]);
        }
        this.println();
    }

    @Override
    public void println(double d) {
        this.println(String.valueOf(d));
    }

    @Override
    public void println(float f) {
        this.println(String.valueOf(f));
    }

    @Override
    public void println(int i) {
        this.println(String.valueOf(i));
    }

    @Override
    public void println(long l) {
        this.println(String.valueOf(l));
    }

    @Override
    public void println(Object o) {
        this.println(o.toString());
    }

    @Override
    public void println(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.print(s.charAt(i));
        }
        this.println();
    }

    @Override
    public void setError() {
        this.error = true;
    }

    public void write(char c) {
        if (c == '\n') {
            this.flush();
        } else if (c != '\r') {
            this.buffer.append(c);
        }
    }

    @Override
    public void write(int c) {
        this.write((char)c);
    }

    @Override
    public void write(char[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            this.write(buf[i]);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = off; i < len; ++i) {
            this.write(buf[i]);
        }
    }

    @Override
    public void write(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void write(String s, int off, int len) {
        for (int i = off; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }
}

