/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMessageResources
extends MessageResources {
    private static final long serialVersionUID = -8425494681357052837L;
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_JSTL = 1;
    private static final int MODE_RESOURCE_BUNDLE = 2;
    private final transient Logger log = LoggerFactory.getLogger(PropertyMessageResources.class);
    protected HashMap<String, String> locales = new HashMap();
    protected HashMap<String, String> messages = new HashMap();
    private int mode = 0;

    public PropertyMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        this.log.trace("Initializing, config='{}'", (Object)config);
    }

    public PropertyMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        this.log.trace("Initializing, config='{}', returnNull={}", (Object)config, (Object)returnNull);
    }

    public void setMode(String mode) {
        String value;
        String string = value = mode == null ? null : mode.trim();
        if ("jstl".equalsIgnoreCase(value)) {
            this.mode = 1;
            this.log.debug("Operating in JSTL compatible mode [{}]", (Object)mode);
        } else if ("resource".equalsIgnoreCase(value)) {
            this.mode = 2;
            this.log.debug("Operating in PropertyResourceBundle compatible mode [{}]", (Object)mode);
        } else {
            this.mode = 0;
            this.log.debug("Operating in Default mode [{}]", (Object)mode);
        }
    }

    @Override
    public String getMessage(Locale locale, String key) {
        this.log.debug("getMessage({},{})", (Object)locale, (Object)key);
        String localeKey = this.localeKey(locale);
        String originalKey = this.messageKey(localeKey, key);
        String message = null;
        message = this.findMessage(locale, key, originalKey);
        if (message != null) {
            return message;
        }
        if (this.mode != 1) {
            if (this.mode == 2) {
                if (!this.defaultLocale.equals(locale)) {
                    message = this.findMessage(this.defaultLocale, key, originalKey);
                }
            } else if (!this.defaultLocale.equals(locale)) {
                localeKey = this.localeKey(this.defaultLocale);
                message = this.findMessage(localeKey, key, originalKey);
            }
        }
        if (message != null) {
            return message;
        }
        message = this.findMessage("", key, originalKey);
        if (message != null) {
            return message;
        }
        if (this.returnNull) {
            return null;
        }
        return "???" + this.messageKey(locale, key) + "???";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadLocale(String localeKey) {
        this.log.trace("loadLocale({})", (Object)localeKey);
        if (this.locales.get(localeKey) != null) {
            return;
        }
        this.locales.put(localeKey, localeKey);
        String name = this.config.replace('.', '/');
        if (localeKey.length() > 0) {
            name = name + "_" + localeKey;
        }
        name = name + ".properties";
        Properties props = new Properties();
        this.log.trace("  Loading resource '{}'", (Object)name);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try (InputStream is = classLoader.getResourceAsStream(name);){
            if (is != null) {
                props.load(is);
                this.log.trace("  Loading resource completed");
            } else {
                this.log.warn("  Resource {} Not Found.", (Object)name);
            }
        }
        catch (IOException e) {
            this.log.error("loadLocale()", (Throwable)e);
        }
        if (props.size() < 1) {
            return;
        }
        HashMap<String, String> hashMap = this.messages;
        synchronized (hashMap) {
            for (Object oKey : props.keySet()) {
                String key = oKey.toString();
                this.log.atTrace().setMessage("  Saving message key '{}'").log(() -> this.messageKey(localeKey, key));
                this.messages.put(this.messageKey(localeKey, key), props.getProperty(key));
            }
        }
    }

    private String findMessage(Locale locale, String key, String originalKey) {
        String localeKey = this.localeKey(locale);
        String message = null;
        int underscore = 0;
        while ((message = this.findMessage(localeKey, key, originalKey)) == null && (underscore = localeKey.lastIndexOf("_")) >= 0) {
            localeKey = localeKey.substring(0, underscore);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findMessage(String localeKey, String key, String originalKey) {
        this.loadLocale(localeKey);
        String messageKey = this.messageKey(localeKey, key);
        boolean addIt = !messageKey.equals(originalKey);
        HashMap<String, String> hashMap = this.messages;
        synchronized (hashMap) {
            String message = this.messages.get(messageKey);
            if (message != null && addIt) {
                this.messages.put(originalKey, message);
            }
            return message;
        }
    }
}

