/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.chain.commands.util.ClassUtils;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.BaseConfig;
import org.apache.struts.config.FormPropertyConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.BeanValidatorForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormBeanConfig
extends BaseConfig {
    private static final long serialVersionUID = -2606605006051449892L;
    private final transient Logger log = LoggerFactory.getLogger(FormBeanConfig.class);
    protected HashMap<String, FormPropertyConfig> formProperties = new HashMap();
    protected String lock = "";
    protected transient DynaActionFormClass dynaActionFormClass;
    protected boolean dynamic = false;
    protected String inherit = null;
    protected boolean extensionProcessed = false;
    protected String name = null;
    protected String type = null;
    protected boolean restricted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynaActionFormClass getDynaActionFormClass() {
        if (!this.dynamic) {
            throw new IllegalArgumentException("ActionForm is not dynamic");
        }
        String string = this.lock;
        synchronized (string) {
            if (this.dynaActionFormClass == null) {
                this.dynaActionFormClass = new DynaActionFormClass(this);
            }
        }
        return this.dynaActionFormClass;
    }

    public boolean getDynamic() {
        return this.dynamic;
    }

    public String getExtends() {
        return this.inherit;
    }

    public void setExtends(String extend) {
        this.throwIfConfigured();
        this.inherit = extend;
    }

    public boolean isExtensionProcessed() {
        return this.extensionProcessed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwIfConfigured();
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.throwIfConfigured();
        this.type = type;
        Class<DynaActionForm> dynaBeanClass = DynaActionForm.class;
        Class<?> formBeanClass = this.formBeanClass();
        this.dynamic = formBeanClass != null ? dynaBeanClass.isAssignableFrom(formBeanClass) : false;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    protected boolean checkCircularInheritance(ModuleConfig moduleConfig) {
        String ancestorName = this.getExtends();
        while (ancestorName != null) {
            if (this.getName().equals(ancestorName)) {
                return true;
            }
            FormBeanConfig ancestor = moduleConfig.findFormBeanConfig(ancestorName);
            ancestorName = ancestor.getExtends();
        }
        return false;
    }

    protected void inheritFormProperties(FormBeanConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this.throwIfConfigured();
        FormPropertyConfig[] baseFpcs = config.findFormPropertyConfigs();
        for (int i = 0; i < baseFpcs.length; ++i) {
            FormPropertyConfig baseFpc = baseFpcs[i];
            FormPropertyConfig prop = this.findFormPropertyConfig(baseFpc.getName());
            if (prop != null) continue;
            prop = (FormPropertyConfig)RequestUtils.applicationInstance(baseFpc.getClass().getName());
            BeanUtils.copyProperties((Object)prop, (Object)baseFpc);
            this.addFormPropertyConfig(prop);
            prop.setProperties(baseFpc.copyProperties());
        }
    }

    public ActionForm createActionForm(ActionServlet servlet) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Object obj = null;
        obj = this.getDynamic() ? this.getDynaActionFormClass().newInstance() : this.formBeanClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ActionForm form = null;
        form = obj instanceof ActionForm ? (ActionForm)obj : new BeanValidatorForm(obj);
        form.setServlet(servlet);
        if (form instanceof DynaBean && ((DynaBean)form).getDynaClass() instanceof MutableDynaClass) {
            DynaBean dynaBean = (DynaBean)form;
            MutableDynaClass dynaClass = (MutableDynaClass)dynaBean.getDynaClass();
            dynaClass.setRestricted(false);
            FormPropertyConfig[] props = this.findFormPropertyConfigs();
            for (int i = 0; i < props.length; ++i) {
                dynaClass.add(props[i].getName(), props[i].getTypeClass());
                dynaBean.set(props[i].getName(), props[i].initial());
            }
            dynaClass.setRestricted(this.isRestricted());
        }
        if (form instanceof BeanValidatorForm) {
            ((BeanValidatorForm)form).initialize(this);
        }
        return form;
    }

    public ActionForm createActionForm(ActionContext context) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        ActionServlet actionServlet = null;
        if (context instanceof ServletActionContext) {
            ServletActionContext saContext = (ServletActionContext)context;
            actionServlet = saContext.getActionServlet();
        }
        return this.createActionForm(actionServlet);
    }

    public boolean canReuse(ActionForm form) {
        if (form != null) {
            if (this.getDynamic()) {
                String className = ((DynaBean)form).getDynaClass().getName();
                if (className.equals(this.getName())) {
                    this.log.debug("Can reuse existing instance (dynamic)");
                    return true;
                }
            } else {
                try {
                    Class<?> configClass;
                    Class<?> formClass = form.getClass();
                    if (form instanceof BeanValidatorForm) {
                        BeanValidatorForm beanValidatorForm = (BeanValidatorForm)form;
                        if (beanValidatorForm.getInstance() instanceof DynaBean) {
                            String formName = beanValidatorForm.getStrutsConfigFormName();
                            if (this.getName().equals(formName)) {
                                this.log.debug("Can reuse existing instance (BeanValidatorForm)");
                                return true;
                            }
                            return false;
                        }
                        formClass = beanValidatorForm.getInstance().getClass();
                    }
                    if ((configClass = ClassUtils.getApplicationClass(this.getType())).isAssignableFrom(formClass)) {
                        this.log.debug("Can reuse existing instance (non-dynamic)");
                        return true;
                    }
                }
                catch (Exception e) {
                    this.log.debug("Error testing existing instance for reusability; just create a new instance", (Throwable)e);
                }
            }
        }
        return false;
    }

    public void addFormPropertyConfig(FormPropertyConfig config) {
        this.throwIfConfigured();
        if (this.formProperties.containsKey(config.getName())) {
            throw new IllegalArgumentException("Property " + config.getName() + " already defined");
        }
        this.formProperties.put(config.getName(), config);
    }

    public FormPropertyConfig findFormPropertyConfig(String name) {
        return this.formProperties.get(name);
    }

    public FormPropertyConfig[] findFormPropertyConfigs() {
        FormPropertyConfig[] results = new FormPropertyConfig[this.formProperties.size()];
        return this.formProperties.values().toArray(results);
    }

    @Override
    public void freeze() {
        super.freeze();
        FormPropertyConfig[] fpconfigs = this.findFormPropertyConfigs();
        for (int i = 0; i < fpconfigs.length; ++i) {
            fpconfigs[i].freeze();
        }
    }

    public void inheritFrom(FormBeanConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this.throwIfConfigured();
        if (this.getName() == null) {
            this.setName(config.getName());
        }
        if (!this.isRestricted()) {
            this.setRestricted(config.isRestricted());
        }
        if (this.getType() == null) {
            this.setType(config.getType());
        }
        this.inheritFormProperties(config);
        this.inheritProperties(config);
    }

    public void processExtends(ModuleConfig moduleConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        String ancestor = this.getExtends();
        if (!this.extensionProcessed && ancestor != null) {
            FormBeanConfig baseConfig = moduleConfig.findFormBeanConfig(ancestor);
            if (baseConfig == null) {
                throw new NullPointerException("Unable to find form bean '" + ancestor + "' to extend.");
            }
            if (this.checkCircularInheritance(moduleConfig)) {
                throw new IllegalArgumentException("Circular inheritance detected for form bean " + this.getName());
            }
            if (!baseConfig.isExtensionProcessed()) {
                baseConfig.processExtends(moduleConfig);
            }
            this.inheritFrom(baseConfig);
        }
        this.extensionProcessed = true;
    }

    public void removeFormPropertyConfig(FormPropertyConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formProperties.remove(config.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FormBeanConfig[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",type=");
        sb.append(this.type);
        sb.append(",extends=");
        sb.append(this.inherit);
        sb.append("]");
        return sb.toString();
    }

    protected Class<?> formBeanClass() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            return classLoader.loadClass(this.getType());
        }
        catch (Exception e) {
            return null;
        }
    }
}

