/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

public abstract class BaseConfig
implements Serializable {
    private static final long serialVersionUID = 7059240587081363820L;
    protected boolean configured = false;
    private Properties properties = new Properties();

    public void freeze() {
        this.configured = true;
    }

    public void throwIfConfigured() {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
    }

    public void setProperty(String key, String value) {
        this.throwIfConfigured();
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected void inheritProperties(BaseConfig baseConfig) {
        this.throwIfConfigured();
        Properties baseProperties = baseConfig.getProperties();
        Enumeration<?> keys = baseProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = this.getProperty(key);
            if (value != null) continue;
            value = baseProperties.getProperty(key);
            this.setProperty(key, value);
        }
    }

    protected Properties copyProperties() {
        Properties copy = new Properties();
        Enumeration<?> keys = this.properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            copy.setProperty(key, this.properties.getProperty(key));
        }
        return copy;
    }
}

