/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands.servlet;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.chain.commands.AbstractPerformForward;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformForward
extends AbstractPerformForward {
    private final Logger log = LoggerFactory.getLogger(PerformForward.class);

    @Override
    protected void perform(ActionContext context, ForwardConfig forwardConfig) throws Exception {
        ServletActionContext sacontext = (ServletActionContext)context;
        String uri = forwardConfig.getPath();
        if (uri == null) {
            ActionServlet servlet = sacontext.getActionServlet();
            MessageResources resources = servlet.getInternal();
            throw new IllegalArgumentException(resources.getMessage("forwardPathNull"));
        }
        HttpServletRequest request = sacontext.getRequest();
        ServletContext servletContext = sacontext.getContext();
        HttpServletResponse response = sacontext.getResponse();
        String actionIdPath = RequestUtils.actionIdURL(forwardConfig, sacontext.getRequest(), sacontext.getActionServlet());
        if (actionIdPath != null) {
            uri = actionIdPath;
            ForwardConfig actionIdForwardConfig = new ForwardConfig(forwardConfig);
            actionIdForwardConfig.setPath(actionIdPath);
            forwardConfig = actionIdForwardConfig;
        }
        if (uri.startsWith("/")) {
            uri = this.resolveModuleRelativePath(forwardConfig, servletContext, request);
        }
        if (response.isCommitted() && !forwardConfig.getRedirect()) {
            this.handleAsInclude(uri, servletContext, request, response);
        } else if (forwardConfig.getRedirect()) {
            this.handleAsRedirect(uri, request, response);
        } else {
            this.handleAsForward(uri, servletContext, request, response);
        }
    }

    private String resolveModuleRelativePath(ForwardConfig forwardConfig, ServletContext servletContext, HttpServletRequest request) {
        String prefix = forwardConfig.getModule();
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(prefix, request, servletContext);
        return RequestUtils.forwardURL(request, forwardConfig, moduleConfig);
    }

    private void handleAsForward(String uri, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher rd = servletContext.getRequestDispatcher(uri);
        this.log.debug("Forwarding to {}", (Object)uri);
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void handleAsRedirect(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (uri.startsWith("/")) {
            uri = request.getContextPath() + uri;
        }
        this.log.debug("Redirecting to {}", (Object)uri);
        response.sendRedirect(response.encodeRedirectURL(uri));
    }

    private void handleAsInclude(String uri, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd = servletContext.getRequestDispatcher(uri);
        if (rd == null) {
            response.sendError(500, "Error getting RequestDispatcher for " + uri);
            return;
        }
        this.log.debug("Including {}", (Object)uri);
        rd.include((ServletRequest)request, (ServletResponse)response);
    }
}

