/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteCommand
extends ActionCommandBase {
    private final Logger log = LoggerFactory.getLogger(ExecuteCommand.class);

    @Override
    protected boolean execute_(ActionContext actionCtx) throws Exception {
        Command<ActionContext> command;
        if (this.shouldProcess(actionCtx) && (command = this.getCommand(actionCtx)) != null) {
            return command.execute((Context)actionCtx);
        }
        return false;
    }

    protected boolean shouldProcess(ActionContext context) {
        Boolean valid = context.getFormValid();
        return valid != null && valid != false;
    }

    protected Command<ActionContext> getCommand(ActionContext context) {
        ActionConfig actionConfig = context.getActionConfig();
        String commandName = actionConfig.getCommand();
        if (commandName == null) {
            return null;
        }
        String catalogName = actionConfig.getCatalog();
        return this.getCommand(commandName, catalogName);
    }

    protected Command<ActionContext> getCommand(String commandName, String catalogName) {
        Catalog catalog;
        if (commandName == null) {
            return null;
        }
        CatalogFactory catalogFactory = CatalogFactory.getInstance();
        if (catalogName != null) {
            catalog = catalogFactory.getCatalog(catalogName);
            if (catalog == null) {
                this.log.warn("When looking up {}, no catalog found under {}", (Object)commandName, (Object)catalogName);
                return null;
            }
        } else {
            catalogName = "the default catalog";
            catalog = catalogFactory.getCatalog();
            if (catalog == null) {
                this.log.warn("When looking up {}, no default catalog found.", (Object)commandName);
                return null;
            }
        }
        this.log.debug("looking up command {} in {}", (Object)commandName, (Object)catalogName);
        return catalog.getCommand(commandName);
    }
}

