/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionCatcher
extends ActionCommandBase
implements Filter<ActionContext> {
    private final Logger log = LoggerFactory.getLogger(ExceptionCatcher.class);
    private String catalogName = null;
    private String exceptionCommand = null;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getExceptionCommand() {
        return this.exceptionCommand;
    }

    public void setExceptionCommand(String exceptionCommand) {
        this.exceptionCommand = exceptionCommand;
    }

    @Override
    protected boolean execute_(ActionContext actionCtx) throws Exception {
        actionCtx.setException(null);
        return false;
    }

    public boolean postprocess(ActionContext actionCtx, Exception exception) {
        if (exception == null) {
            return false;
        }
        this.log.debug("Attempting to handle a thrown exception");
        actionCtx.setException(exception);
        try {
            Command<ActionContext> command = this.lookupExceptionCommand();
            if (command == null) {
                this.log.error("Cannot find exceptionCommand '{}'", (Object)this.exceptionCommand);
                throw new IllegalStateException("Cannot find exceptionCommand '" + this.exceptionCommand + "'");
            }
            this.log.trace("Calling exceptionCommand '{}'", (Object)this.exceptionCommand);
            command.execute((Context)actionCtx);
        }
        catch (Exception e) {
            this.log.warn("Exception from exceptionCommand '{}'", (Object)this.exceptionCommand, (Object)e);
            IllegalStateException e2 = new IllegalStateException("Exception chain threw exception");
            e2.initCause(e);
            throw e2;
        }
        return true;
    }

    protected Command<ActionContext> lookupExceptionCommand() {
        String exceptionCommand;
        Catalog catalog;
        String catalogName = this.getCatalogName();
        CatalogFactory catalogFactory = CatalogFactory.getInstance();
        if (catalogName == null) {
            catalog = catalogFactory.getCatalog();
            if (catalog == null) {
                this.log.error("Cannot find default catalog");
                throw new IllegalArgumentException("Cannot find default catalog");
            }
        } else {
            catalog = catalogFactory.getCatalog(catalogName);
            if (catalog == null) {
                this.log.error("Cannot find catalog '{}'", (Object)catalogName);
                throw new IllegalArgumentException("Cannot find catalog '" + catalogName + "'");
            }
        }
        if ((exceptionCommand = this.getExceptionCommand()) == null) {
            this.log.error("No exceptionCommand property specified");
            throw new IllegalStateException("No exceptionCommand property specfied");
        }
        return catalog.getCommand(exceptionCommand);
    }
}

