/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import java.util.Map;
import org.apache.struts.action.ActionForm;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateActionForm
extends ActionCommandBase {
    private final Logger log = LoggerFactory.getLogger(CreateActionForm.class);

    @Override
    protected boolean execute_(ActionContext actionCtx) throws Exception {
        ActionConfig actionConfig = actionCtx.getActionConfig();
        String name = actionConfig.getName();
        if (name == null) {
            actionCtx.setActionForm(null);
            return false;
        }
        this.log.trace("Look up form-bean {}", (Object)name);
        FormBeanConfig formBeanConfig = actionConfig.getModuleConfig().findFormBeanConfig(name);
        if (formBeanConfig == null) {
            this.log.warn("No FormBeanConfig found in module {} under name {}", (Object)actionConfig.getModuleConfig().getPrefix(), (Object)name);
            actionCtx.setActionForm(null);
            return false;
        }
        Map<String, Object> scope = actionCtx.getScope(actionConfig.getScope());
        ActionForm instance = (ActionForm)scope.get(actionConfig.getAttribute());
        if (!formBeanConfig.canReuse(instance)) {
            instance = formBeanConfig.createActionForm(actionCtx);
        }
        if (actionCtx instanceof ServletActionContext) {
            ServletActionContext sac = (ServletActionContext)actionCtx;
            instance.setServlet(sac.getActionServlet());
        }
        actionCtx.setActionForm(instance);
        scope.put(actionConfig.getAttribute(), instance);
        return false;
    }
}

